/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "config.h"
#include "WidgetApolloPluginWin.h"
#include "IScrollViewApolloImpl.h"
#include "../../../../WebCore/plugins/PluginView.h"
#include "FrameTree.h"
#include "FrameView.h"
#include "WebFrameImpl.h"

namespace WebKitApollo
{
    WidgetApolloPluginWinImpl::WidgetApolloPluginWinImpl(WebCore::PluginView* pluginView
                                                        , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                                                        , WebViewImpl* const webView)
		:	WebPluginWidgetImpl(webView)
		,	m_pPluginView(pluginView)
	{
		ASSERT( pluginView);

        // can't set this here as we need setParent in this class called
        //WebWidgetImpl::setParent( parentScrollViewImpl );
	}

	WidgetApolloPluginWinImpl::~WidgetApolloPluginWinImpl()
	{
	}

    WTF::PassRefPtr< WidgetApolloPluginWinImpl > WidgetApolloPluginWinImpl::construct(WebCore::PluginView* pluginView
                                , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                                , WebViewImpl* const webView)
	{
		return WTF::adoptRef< WidgetApolloPluginWinImpl >( new WidgetApolloPluginWinImpl(pluginView, parentScrollViewImpl, webView) );
	}
	
	bool WidgetApolloPluginWinImpl::handleMousePressEvent(const WebCore::PlatformMouseEvent& mouseEvent)
	{
		ASSERT( false );
        return false;
	}
	
    bool WidgetApolloPluginWinImpl::handleMouseMoveEvent(const WebCore::PlatformMouseEvent& mouseEvent)
	{
		ASSERT( false );
        return false;
	}
	
    bool WidgetApolloPluginWinImpl::handleMouseReleaseEvent(const WebCore::PlatformMouseEvent& mouseEvent)
	{
		ASSERT( false );
        return false;
	}
    
	bool WidgetApolloPluginWinImpl::handleKeyboardEvent(const WebCore::PlatformKeyboardEvent& keyEvent)
	{
		ASSERT( false );
        return false;
	}

    bool WidgetApolloPluginWinImpl::handleInsertText(const WebCore::String&)
    {
        ASSERT(false);
        return false;
    }

    void WidgetApolloPluginWinImpl::setParent(WebCore::IScrollViewApolloImpl* parent)
    {
        WebWidgetImpl::setParent( parent );

        m_pPluginView->init();
        m_pPluginView->setNPWindowRect(m_pPluginView->frameGeometry());
    }

	PassRefPtr<KJS::Bindings::Instance> WidgetApolloPluginWinImpl::getInstance(WebCore::Frame *frame)
	{
		return m_pPluginView->bindingInstance();
	}

	void* WidgetApolloPluginWinImpl::createPluginScriptableObject()
	{
		ASSERT(false);
		return 0;
	}

	void WidgetApolloPluginWinImpl::releasePluginScriptableObject(void *)
	{
		ASSERT(false);
	}

    
    void WidgetApolloPluginWinImpl::setFocus()
    {
        // Don't do anything....
        // PluginViewIn called Document::setFocusNode, we don't want the
        // WebView's focus controller code to put focus directly on us.
    }

    void WidgetApolloPluginWinImpl::show()
    {
        // empty implementation because the only way we get here
        // is from Widget::show which is called by PluginViewWin::show.
        // empty implementation needed to avoid infinite recursion.
    }

    void WidgetApolloPluginWinImpl::hide()
    {
        // empty implementation because the only way we get here
        // is from Widget::hide which is called by PluginViewWin::hide.
        // empty implementation needed to avoid infinite recursion.
    }

    bool WidgetApolloPluginWinImpl::handleWheelEvent(WebCore::PlatformWheelEvent& wheelEvent)
    {
        ASSERT(false);
        return false;
    }

    WebCore::Widget* WidgetApolloPluginWinImpl::getWidget()
    {
        ASSERT(m_pPluginView);
        return m_pPluginView;
    }

    void WidgetApolloPluginWinImpl::paint(WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect)
    {
        ASSERT(false);
        // We should never get here because we override Widget::paint on the PluginViewMac class.
    }

    void WidgetApolloPluginWinImpl::updatePluginWindow(bool showPlugins, bool showWindowedPlugins)
    {
        bool const showPlugin = m_pPluginView->isWindowed() ? showWindowedPlugins : showPlugins;
        m_pPluginView->enableOrSuppress(showPlugin);
        
		//	All events, including paint, may indicate that we have to
		//	resize.  This is because our drawing model (nested HWNDs)
		//	doesn't match the Apollo drawing model (one HWND).  Setting
		//	us to the same geometry will make this call do the window-
		//	relative math and all the clipping stuff, and call back
		//	frameGeometryHasChanged if it really has.
		m_pPluginView->setFrameGeometry( m_pPluginView->frameGeometry() );
    }

    WTF::PassRefPtr<WebCore::IPluginWidgetApolloImpl> WidgetApolloPluginWinImpl::toPluginWidgetImpl()
    {
        return WTF::PassRefPtr<WebCore::IPluginWidgetApolloImpl>(static_cast<WebCore::IPluginWidgetApolloImpl*>(this));
    }

    WebCore::ResourceHandleClient* WidgetApolloPluginWinImpl::pluginRedirectClient()
    {
        return this;
    }

    void WidgetApolloPluginWinImpl::didReceiveResponse(WebCore::ResourceHandle*, const WebCore::ResourceResponse& response) 
    {
        m_pPluginView->didReceiveResponse(response);
    }
    
    void WidgetApolloPluginWinImpl::didReceiveData(WebCore::ResourceHandle*, const char* data, int, int lengthReceived) 
    { 
        m_pPluginView->didReceiveData(data, lengthReceived);
    }
    
    void WidgetApolloPluginWinImpl::didFinishLoading(WebCore::ResourceHandle*) 
    {
        m_pPluginView->didFinishLoading();
    }

    void WidgetApolloPluginWinImpl::didFail(WebCore::ResourceHandle*, const WebCore::ResourceError& error) 
    {
        m_pPluginView->didFail(error);
    }
}
