#ifndef APOLLO_WEBKIT_PLUGIN_PDF_IMPL_WIN_H
#define APOLLO_WEBKIT_PLUGIN_PDF_IMPL_WIN_H

#include "WebPluginNP.h"
#include "npruntime.h" 
#include "npfunctions.h"
#include "CString.h"
#include "Timer.h"
#include <wtf/Vector.h>

class ResourceLoaderClient;
class ResourceLoader;

extern "C"
{
	//	We make a special call to the plug-in with this structure; there is a copy of
	//	this structure in NS_PDFX.cpp, but since it's in a different perforce depot
	//	we can't share it.
	//	For the Apollo entry point, on an instance-by-instance bases.
	typedef void (*ApolloBeginModalProc)(NPP instance);
	typedef void (*ApolloEndModalProc)(NPP instance);

	#define	APOLLO_ENTRY_PARAM_VERSION			1

	typedef struct _ApolloEntryParam {
		unsigned long			size;
		unsigned long			apolloVersion;
		ApolloBeginModalProc	beginModal;
		ApolloEndModalProc		endModal;
	} ApolloEntryParamRec, *ApolloEntryParam;

	typedef NPError (WINAPI *NP_ApolloEntryFuncPtr)( ApolloEntryParam apolloEntryParams );
}


namespace WebKitApollo
{
	class NPStreamWrapper 
	{
	public:
		NPStreamWrapper(NPStream *pStream, bool isDocStream):
	        m_NPStream(pStream),
	        m_bIsDocStream(isDocStream),
	        m_StreamOffset(0),
	        m_notifyData(NULL),
	        m_bIsStarted(false),
	        m_bIsDead(false)
		{
		}

		NPStreamWrapper(NPStream *pStream, const WebCore::KURL& kurl, bool isDocStream):
		    m_NPStream(pStream),
			m_bIsDocStream(isDocStream),
			m_StreamOffset(0),
			m_notifyData(NULL),
			m_bIsStarted(false),
			m_bIsDead(false)
		{
            setURL(kurl);
		}

        ~NPStreamWrapper()                      { if (m_NPStream) { delete m_NPStream; m_NPStream = NULL; } };
		NPStream * getNPStream()                { return m_NPStream; }
		void setStreamOffset(int32 inOffset)    { m_StreamOffset = inOffset; }
		int32 getStreamOffset ()                { return m_StreamOffset; }
		void setIsDocStream(bool isDocStream)   { m_bIsDocStream = isDocStream; }
		bool getIsDocStream()                   { return m_bIsDocStream; }
		void setNotifyData(void * notifyData)   { m_notifyData = notifyData; }
		void *getNotifyData()                   { return m_notifyData; }
		void setIsStarted(bool bIsStarted)      { m_bIsStarted= bIsStarted; }
		bool getIsStarted( )                    { return m_bIsStarted; }
		bool getIsDead()                        { return m_bIsDead; }
		void setIsDead(bool IsDead)             { m_bIsDead = IsDead; }
    
        WebCore::KURL getURL()                  { return m_url; }
        void setURL(const WebCore::KURL& kurl)
        {
            m_url = kurl;

            WebCore::String const urlStr( m_url.prettyURL() );

            m_urlUtf8 = urlStr.utf8();
            m_NPStream->url = m_urlUtf8.data();
        }
	private:
		NPStream *m_NPStream;
		int32 m_StreamOffset;
		bool m_bIsDocStream;
		void *m_notifyData;
		bool m_bIsStarted;
		bool m_bIsDead;
        WebCore::KURL m_url;
        WebCore::CString m_urlUtf8;
	};

    class CFile
    {
    public:
        CFile() : m_file(0) { m_filePath[0] = 0; }
        ~CFile() { remove(); }

        void close();
        void remove();
        void initAsTemp();

        void write(const char* bytes, size_t numBytes);

        operator FILE*() { return m_file; }
        char* getPath() { return (char*)m_filePath; }
    private:
        CFile(const CFile&);
        CFile& operator=(const CFile&);
    private:
        FILE* m_file;
        char m_filePath[MAX_PATH]; // need char* path due to Netscape interface
    };

	// more or less equal to WebNetscapePluginPackage + WebBaseBaseNetscapePluginView + FrameMac.mm
	class PluginPDFImplWin :	public PluginNP
	{
	public:
		PluginPDFImplWin(	WebCore::Element *element,
							const WebCore::KURL& url,
							const Vector<WebCore::String>& paramNames, 
							const Vector<WebCore::String>& paramValues,
							const WebCore::String& mimeType,
							WebFrameImpl* const pWebFrameOwner );

		virtual ~PluginPDFImplWin();
	
		/* XXX Liz Todo ... From ApolloWebFrameImpl.* 
		virtual void submitForm( const WebCore::ResourceRequest& request );
		virtual void setTitle(const WebCore::String& title);
		virtual void setStatusText(const WebCore::String& title);
		*/

		static bool PluginExists();

		virtual void updatePluginWindow(bool showPlugins, bool showWindowedPlugins);
	protected:
		//Overrides of PluginImpl
		virtual void frameGeometryHasChanged( const WebCore::IntRect &oldRect, const WebCore::IntRect& windowRect, const WebCore::IntRect& windowClipRect);
	
		//Overrides of WebCore::ResourceLoaderClient.  This will thunk back to the 
		void clientReceivedRedirect(void *client, WebCore::ResourceHandle*, const WebCore::KURL&);
		void clientReceivedResponse(void *client, WebCore::ResourceHandle*, const WebCore::ResourceResponse&);
		void clientReceivedData(void *client, WebCore::ResourceHandle*, const char*, int);
		void clientReceivedAllData(void *client, WebCore::ResourceHandle*);

		//	This returns the resource loader client if we want it redirected from the Frame.
		virtual WebCore::ResourceHandleClient *pluginRedirectClient() { return this; };

		void CallNPPSetWindowIfAppropriate(void);

		//Overrides of WidgetImpl
		virtual void* createPluginScriptableObject();
		virtual void releasePluginScriptableObject(void* object);
	private:
		// Netscape plug-in packages must be explicitly opened and closed by each plug-in instance.
		// This is to protect Netscape plug-ins from being unloaded while they are in use
		static void open( PluginPDFImplWin *pdfImplWin );
		static void close( PluginPDFImplWin *pdfImplWin );

		bool start();
		bool stop(NPError reason = NPRES_USER_BREAK, bool inDestructor = false);
	private:
		static bool load( PluginPDFImplWin *pdfImplWin );
		static bool unload( PluginPDFImplWin *pdfImplWin );
		void dealloc();
		void freeAttributeKeysAndValues();
		void updateWindow();
        bool hasWindowParent();

        NPStreamWrapper* createNewStream(const WebCore::KURL& kURL, void* notifyData);
        bool releaseStream(NPStreamWrapper* pStream);
	private: // per instance items
		NPWindow m_window;
		bool m_isStarted;
        bool m_isVisible;
		bool m_isTransparent;
		HWND m_hwnd;
	    NPObject* m_windowScriptNPObject;
		unsigned int m_pluginFunctionCallDepth;
		bool m_shouldStopSoon;
		NPP_t m_instanceStruct;
		NPP m_instance;
		int m_mode;
		int m_specifiedHeight;
		int m_specifiedWidth;
		char **m_cAttributes;
		char **m_cValues;
		NPStreamWrapper * m_docStream;// This is the document stream.  There can be other streams (AUX) for multimedia, FDF
		WebCore::CString m_userAgent;
		uint16 m_sType;
		bool m_instanceIsDead; // The instance may be dead due to network error. If so, don't call NPP_*
        CFile m_tempFile;

		// Resource loader callbacks use this to figure out which stream
		NPStreamWrapper *streamWrapperFromClient( void *client );

		// Keep track of aux streams in order to stop them and free them
		void cleanUpAuxStreams();
		WTF::Vector< NPStreamWrapper * >::iterator findAuxStream( NPStreamWrapper * const pStream );
		void removeAuxStream(NPStreamWrapper * const pStream );
		WTF::Vector<NPStreamWrapper *> m_auxStreams; // These are currently open Aux streams (form posting, multimedia, URL fragments)

		NPError setVariable(NPPVariable variable, void* value);
		NPError getVariable(NPNVariable variable, void *value);
		void invalidateRegion(HRGN invalidRegion);
		void invalidateRect(const RECT& invalidRect);

		NPObject* windowScriptNPObject();
		NPObject* getElementNPObject();

		// NPN_PostURL
		// XXX ToDo:  we can currently only handle one POST at a time where the return type is HTML
		// For the IE ActiveX, we had to fix this by allowing multiple posts at the same time with a list 
		// of outstanding posts.  This limitation currently only applies to Posts from PDF where the return
		// type is not an Adobe format (and therefore goes to the frame).
		NPError postURL(NPP instance, const char* URL, const char* target, uint32 len, const char* buf, NPBool file);
		NPError postURLHelper(const WebCore::KURL& kURL, WebCore::Frame *pFrame, const WTF::Vector<char>& buf);
		WebCore::Timer<PluginPDFImplWin> m_delayedPostTimer;
		void delayedPostTimerFired(WebCore::Timer<PluginPDFImplWin>*);
		WebCore::KURL	m_postURL;
		WTF::Vector<char> m_buf;

		//	Special case: DOUBLE POST.  This is all so we can re-use a request due to a bug in NS_PDFX (Acrobat).
		bool m_inClientReceivedResponse;
		WebCore::ResourceHandle *m_clientReceivedResponseResourceHandle;
		bool m_useDoublePOSTRequest;
		WebCore::ResourceRequest m_doublePOSTRequest;

		// NPN_GetURL and NPN_GetURLNotify
		NPError getURLNotify(const char* URL, const char* target, void* notifyData);
		NPError getURLNotifyHelper(WebCore::KURL kURL, WebCore::Frame * pFrame, void* notifyData);

		NPError allowURL(const char *URL, const char *target);

		WebCore::Timer<PluginPDFImplWin> m_delayedGetTimer;
		void delayedGetTimerFired(WebCore::Timer<PluginPDFImplWin>*);
		WebCore::KURL	m_getURL;
		void *m_notifyData;

		void willCallPlugInFunction();
		void didCallPlugInFunction();

		void setAttributeKeys();
		WebCore::KURL getBaseURL();

		// XXX - to be updated with Apollo equivalents
		void invalidate();
		void draw();

	private: // per DLL items

		static HINSTANCE			m_hInst;
		static WebCore::String		m_path;
		static unsigned int			m_instanceCount;
		static NPPluginFuncs		m_pluginFuncs;
		static NPNetscapeFuncs		m_browserFuncs;
		static NPP_ShutdownProcPtr	mNP_Shutdown;
		static Vector<PluginPDFImplWin*> mCurrentPluginImpl;
		static WebCore::QualifiedName*		mEmbedTag;
		static WebCore::QualifiedName*		mObjectTag;
		static WebCore::AtomicString*		mNullAtom;
		static ApolloEntryParamRec		m_apolloEntryFuncs;

		static void initStructs();
		static PluginPDFImplWin* GetInstancePointer(NPP instance);

		// general plug-in to browser functions
		static void* NPN_MemAlloc(uint32 size);
		static void NPN_MemFree(void* ptr);
		static uint32 NPN_MemFlush(uint32 size);
		static void NPN_ReloadPlugins(NPBool reloadPages);
		static NPError NPN_RequestRead(NPStream* stream, NPByteRange* rangeList);
	
		// instance-specific functions
		// ndata is always PluginPDFImplWin*. Sometimes, plug-ins will call an instance-specific function
		// with a NULL instance.  Since Acrobat doesn't do this we don't cache the last used PluginPDFImplWin*
		static NPError NPN_GetURLNotify(NPP instance, const char* URL, const char* target, void* notifyData);
		static NPError NPN_GetURL(NPP instance, const char* URL, const char* target);
		static NPError NPN_PostURLNotify(NPP instance, const char* URL, const char* target, uint32 len, const char* buf, NPBool file, void* notifyData);
		static NPError NPN_PostURL(NPP instance, const char* URL, const char* target, uint32 len, const char* buf, NPBool file);
		static NPError NPN_NewStream(NPP instance, NPMIMEType type, const char* target, NPStream** stream);
		static int32 NPN_Write(NPP instance, NPStream* stream, int32 len, void* buffer);
		static NPError NPN_DestroyStream(NPP instance, NPStream* stream, NPReason reason);
		static const char* NPN_UserAgent(NPP instance);
		static void NPN_Status(NPP instance, const char* message);
		static void NPN_InvalidateRect(NPP instance, NPRect *invalidRect);
		static void NPN_InvalidateRegion(NPP instance, NPRegion invalidRegion);
		static void NPN_ForceRedraw(NPP instance);
		static NPError NPN_GetValue(NPP instance, NPNVariable variable, void *value);
		static NPError NPN_SetValue(NPP instance, NPPVariable variable, void *value);
		static void* NPN_GetJavaEnv(void);
		static void* NPN_GetJavaPeer(NPP instance);

		// instance-specific functions from the plug-ins.  In some cases the instance can
		// be nil, so we keep a static around that is the value when it's nil.
		static void NPA_BeginModal(NPP instance);
		static void NPA_EndModal(NPP instance);
		static PluginPDFImplWin *sPluginPDFBeingInitialized;
	};
}

#endif
