/*
 * Copyright 2007 Adobe Systems Incorporated. All Rights Reserved.
 * Copyright (C) 2006 Apple Computer, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
#ifndef WebPluginUnix_h
#define WebPluginUnix_h

#include "IWidgetApolloImpl.h"
#include "Font.h"
#include <Cursor.h>
#include "WebPluginWidgetImpl.h"
#include "ResourceHandleClient.h"

namespace WebCore {
    class PluginView;
}

namespace WebKitApollo
{
    class WidgetApolloPluginUnixImpl : public WebPluginWidgetImpl, WebCore::ResourceHandleClient
    {
    protected:
        WidgetApolloPluginUnixImpl(WebCore::PluginView* pluginView
                                   , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                                   , WebViewImpl* const);
        virtual ~WidgetApolloPluginUnixImpl();
    public:
        static WTF::PassRefPtr< WidgetApolloPluginUnixImpl > construct(WebCore::PluginView* pluginView
                                                                   , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                                                                   , WebViewImpl* const);

        virtual PassRefPtr<KJS::Bindings::Instance> getInstance(WebCore::Frame *frame);
        virtual void* createPluginScriptableObject();
        virtual void releasePluginScriptableObject(void *object);

		virtual void setFocus();
		virtual void show();
		virtual void hide();
        
        //These methods are needed on the APOLLO platform because
        //there is no other way for a "widget" to receive input events.
        //The ApolloWebKit::ApolloWebFrameImpl calls the methods to pass events
        //to its childrent WebCore::Widgets.  These WebCore::Widget could really be
        //frames or iframes.
        virtual bool sendContextMenuEvent( const WebCore::PlatformMouseEvent& mouseEvent );
        virtual bool handleMousePressEvent( const WebCore::PlatformMouseEvent& mouseEvent );
        virtual bool handleMouseMoveEvent( const WebCore::PlatformMouseEvent& mouseEvent );
        virtual bool handleMouseReleaseEvent( const WebCore::PlatformMouseEvent& mouseEvent );
        virtual bool handleKeyboardEvent( const WebCore::PlatformKeyboardEvent& keyEvent );
        virtual bool handleWheelEvent(WebCore::PlatformWheelEvent& wheelEvent);
        virtual bool handleInsertText(const WebCore::String& text);
        
        virtual void setParent(WebCore::IScrollViewApolloImpl*);
        virtual void paint(WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect);
        virtual void updatePluginWindow(bool showPlugins, bool showWindowedPlugins);
        virtual WTF::PassRefPtr<WebCore::IPluginWidgetApolloImpl> toPluginWidgetImpl();
        virtual WebCore::ResourceHandleClient* pluginRedirectClient();

        virtual void didReceiveResponse(WebCore::ResourceHandle*, const WebCore::ResourceResponse&);
        virtual void didReceiveData(WebCore::ResourceHandle*, const char*, int, int lengthReceived);
        virtual void didFinishLoading(WebCore::ResourceHandle*);
        virtual void didFail(WebCore::ResourceHandle*, const WebCore::ResourceError&);
    protected:
        virtual WebCore::Widget* getWidget();

    private:
        WebCore::PluginView* m_pPluginView;
    };
}


#endif
