/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "config.h"
#include "ResourceHandle.h"
#include "WidgetApolloPluginUnix.h"
#include "IScrollViewApolloImpl.h"
#include "../../../../WebCore/plugins/PluginView.h"
#include "FrameTree.h"
#include "FrameView.h"
#include "WebFrameImpl.h"

namespace WebKitApollo
{
    WidgetApolloPluginUnixImpl::WidgetApolloPluginUnixImpl(WebCore::PluginView* pluginView
                                                           , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                                                           , WebViewImpl* const webView)
        :    WebPluginWidgetImpl(webView)
        ,    m_pPluginView(pluginView)
    {
        ASSERT( pluginView);

        // can't set this here as we need setParent in this class called
        //WebWidgetImpl::setParent( parentScrollViewImpl );
    }

    WidgetApolloPluginUnixImpl::~WidgetApolloPluginUnixImpl()
    {
    }

    WTF::PassRefPtr< WidgetApolloPluginUnixImpl > WidgetApolloPluginUnixImpl::construct(WebCore::PluginView* pluginView
                                                                                    , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                                                                                    , WebViewImpl* const webView)
    {
        return WTF::adoptRef< WidgetApolloPluginUnixImpl >( new WidgetApolloPluginUnixImpl(pluginView, parentScrollViewImpl, webView) );
    }
    
    bool WidgetApolloPluginUnixImpl::sendContextMenuEvent(const WebCore::PlatformMouseEvent& mouseEvent)
    {
        ASSERT( false );
        return true;
    }

    bool WidgetApolloPluginUnixImpl::handleMousePressEvent(const WebCore::PlatformMouseEvent& mouseEvent)
    {
        ASSERT( false );
        return false;
    }
    
    bool WidgetApolloPluginUnixImpl::handleMouseMoveEvent(const WebCore::PlatformMouseEvent& mouseEvent)
    {
        ASSERT( false );
        return false;
    }
    
    bool WidgetApolloPluginUnixImpl::handleInsertText(const WebCore::String& text)
    {	
        ASSERT(false);
        return false;
    }

    bool WidgetApolloPluginUnixImpl::handleMouseReleaseEvent(const WebCore::PlatformMouseEvent& mouseEvent)
    {
        ASSERT( false );
        return false;
    }
    
    bool WidgetApolloPluginUnixImpl::handleKeyboardEvent(const WebCore::PlatformKeyboardEvent& keyEvent)
    {
        ASSERT( false );
        return false;
    }

    void WidgetApolloPluginUnixImpl::setParent(WebCore::IScrollViewApolloImpl* parent)
    {
        WebWidgetImpl::setParent( parent );

        m_pPluginView->init();
    }

		// TODO_AIRLinux: This might be required here
		//m_pPluginView->setNPWindowRect(m_pPluginView->frameGeometry()); 	

    PassRefPtr<KJS::Bindings::Instance> WidgetApolloPluginUnixImpl::getInstance(WebCore::Frame *frame)
    {
        return m_pPluginView->bindingInstance().get();
    }

    void* WidgetApolloPluginUnixImpl::createPluginScriptableObject()
    {
        ASSERT(false);
        return 0;
    }

    void WidgetApolloPluginUnixImpl::releasePluginScriptableObject(void *)
    {
        ASSERT(false);
    }


	void WidgetApolloPluginUnixImpl::setFocus()
	{
		// Don't do anything....
		// PluginViewIn called Document::setFocusNode, we don't want the
		// WebView's focus controller code to put focus directly on us.
	}

	void WidgetApolloPluginUnixImpl::show()
	{
		// empty implementation because the only way we get here
		// is from Widget::show which is called by PluginViewUnixImpl::show.
		// empty implementation needed to avoid infinite recursion.
	}

	void WidgetApolloPluginUnixImpl::hide()
	{
		// empty implementation because the only way we get here
		// is from Widget::hide which is called by PluginViewUnixImpl::hide.
		// empty implementation needed to avoid infinite recursion.
	}

    bool WidgetApolloPluginUnixImpl::handleWheelEvent(WebCore::PlatformWheelEvent& wheelEvent)
    {
        ASSERT(false);
        return false;
    }

    WebCore::Widget* WidgetApolloPluginUnixImpl::getWidget()
    {
        ASSERT(m_pPluginView);
        return m_pPluginView;
    }

    void WidgetApolloPluginUnixImpl::paint(WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect)
    {
        ASSERT(false);
        // We should never get here because we override Widget::paint on the PluginViewMac class.
    }

    void WidgetApolloPluginUnixImpl::updatePluginWindow(bool showPlugins, bool showWindowedPlugins)
    {
        bool const enable = m_pPluginView->isWindowed() ? showWindowedPlugins : showPlugins;
        m_pPluginView->enableOrSuppress(enable);

        //All events, including paint, may indicate that we have to
        //resize.  This is because our drawing model (nested windows)
        //doesn't match the Apollo drawing model (one window).  Setting
        //us to the same geometry will make this call do the window-
        //relative math and all the clipping stuff, and call back
        //frameGeometryHasChanged if it really has.
        m_pPluginView->setFrameGeometry( m_pPluginView->frameGeometry() );
    }

    WTF::PassRefPtr<WebCore::IPluginWidgetApolloImpl> WidgetApolloPluginUnixImpl::toPluginWidgetImpl()
    {
        return WTF::PassRefPtr<WebCore::IPluginWidgetApolloImpl>(static_cast<WebCore::IPluginWidgetApolloImpl*>(this));
    }

    WebCore::ResourceHandleClient* WidgetApolloPluginUnixImpl::pluginRedirectClient()
    {
        return this;
    }

    void WidgetApolloPluginUnixImpl::didReceiveResponse(WebCore::ResourceHandle*, const WebCore::ResourceResponse& response) 
    {
        m_pPluginView->didReceiveResponse(response);
    }
    
    void WidgetApolloPluginUnixImpl::didReceiveData(WebCore::ResourceHandle*, const char* data, int, int lengthReceived) 
    { 
        m_pPluginView->didReceiveData(data, lengthReceived);
    }
    
    void WidgetApolloPluginUnixImpl::didFinishLoading(WebCore::ResourceHandle*) 
    {
        m_pPluginView->didFinishLoading();
    }

    void WidgetApolloPluginUnixImpl::didFail(WebCore::ResourceHandle*, const WebCore::ResourceError& error) 
    {
        m_pPluginView->didFail(error);
    }

}
