#ifndef WEB_PLUGIN_PDF_IMPL_MAC_H
#define WEB_PLUGIN_PDF_IMPL_MAC_H

#include "WebPluginWK.h"
#include "WebPDFPluginProtocol.h"

namespace WebKitApollo
{
	class PluginPDFImplMac : public PluginWK
	{
	public:
		PluginPDFImplMac(	WebCore::Element *element,
							const WebCore::KURL& url,
							const Vector<WebCore::String>& paramNames, 
							const Vector<WebCore::String>& paramValues,
							const WebCore::String& mimeType,
							WebFrameImpl* const pWebFrameOwner );
		virtual ~PluginPDFImplMac();

	//Our class
	public:
		bool load();
	
	public:
    virtual void updatePluginWindow(bool showPlugins, bool showWindowedPlugins);

	//
	public:
		virtual void paint( WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect );
        virtual void show();
        virtual void hide();
        
	//Overrides of PluginImpl
	protected:
		virtual void frameGeometryHasChanged( const WebCore::IntRect &oldRect, const WebCore::IntRect& windowRect, const WebCore::IntRect& windowClipRect );

	protected:
		//Overrides of WidgetImpl
		virtual void* createPluginScriptableObject();
		virtual void releasePluginScriptableObject(void* object);

	public:
		void PluginPDFImplMac::loadNSURLRequestInFrame( void *request, WebCore::Frame *targetFrame );

	#if IMP_EXTERNAL_RESOURCE_LOADER
		protected:
			//Overrides of WebCore::ResourceLoaderClient.  This will thunk back to the 
			void clientReceivedRedirect(void *client, WebCore::ResourceLoader*, const WebCore::KURL&);
			void clientReceivedResponse(void *client, WebCore::ResourceLoader*, WebCore::PlatformResponse);
			void clientReceivedData(void *client, WebCore::ResourceLoader*, const char*, int);
			void clientReceivedAllData(void *client, WebCore::ResourceLoader*);
			void clientReceivedAllData(void *client, WebCore::ResourceLoader*, WebCore::PlatformData);

		public:
			void pluginLoadURLRequest( WebCore::KURL& url, void *pluginClient );
	#endif

	private:
		void *		mObjCBridge;
		bool		mEverGotNonzeroSize;
	};
}

#endif
