/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
#ifndef WebNPPluginWidgetImplMac_h
#define WebNPPluginWidgetImplMac_h

#include <wtf/PassRefPtr.h>
#include "WebWidgetImpl.h"
#include "WebPluginWidgetImpl.h"
#include "ResourceHandleClient.h"

namespace WebCore {
    class PluginView;
    class IScrollViewApolloImpl;
}

namespace WebKitApollo {

class WebViewImpl;

class WebNPPluginWidgetImplMac : public WebPluginWidgetImpl, WebCore::ResourceHandleClient
{
    friend class WTF::PassRefPtr<WebNPPluginWidgetImplMac>;
    friend class WTF::RefPtr<WebNPPluginWidgetImplMac>;
private:
    WebNPPluginWidgetImplMac(WebCore::PluginView*
                            , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                            , WebViewImpl* const);
    virtual ~WebNPPluginWidgetImplMac();
public:
    static WTF::PassRefPtr<WebNPPluginWidgetImplMac> construct(WebCore::PluginView*
                                                              , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                                                              , WebViewImpl* const);
                                                              
    virtual PassRefPtr<KJS::Bindings::Instance> getInstance(WebCore::Frame*);
    virtual void* createPluginScriptableObject();
    virtual void releasePluginScriptableObject(void* object);
                                                              
    virtual bool handleMousePressEvent(const WebCore::PlatformMouseEvent& mouseEvent);
    virtual bool handleMouseMoveEvent(const WebCore::PlatformMouseEvent& mouseEvent);
    virtual bool handleMouseReleaseEvent(const WebCore::PlatformMouseEvent& mouseEvent);
    virtual bool handleWheelEvent(WebCore::PlatformWheelEvent& wheelEvent);
    virtual bool handleKeyboardEvent( const WebCore::PlatformKeyboardEvent& keyEvent );
    virtual bool handleInsertText(const WebCore::String& text);
    virtual bool handleCut();
    virtual bool handleCopy();
    virtual bool handlePaste();
    virtual bool handleSelectAll();
                                    
    virtual void setParent(WebCore::IScrollViewApolloImpl* parent);
    virtual void paint(WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect);
    
    virtual void onFocus();
    virtual void onBlur();

    virtual bool widgetNeedsMouseDownFromEventHandler() const;

    virtual WebCore::ResourceHandleClient* pluginRedirectClient();
    
    // ResourceHandleClient
    virtual void didReceiveResponse(WebCore::ResourceHandle*, const WebCore::ResourceResponse&);
    virtual void didReceiveData(WebCore::ResourceHandle*, const char*, int, int lengthReceived);
    virtual void didFinishLoading(WebCore::ResourceHandle*);
    virtual void didFail(WebCore::ResourceHandle*, const WebCore::ResourceError&);    
    
    virtual void updatePluginWindow(bool showPlugins, bool showWindowedPlugins);
protected:
    virtual WebCore::Widget* getWidget();
    
private:
    WebNPPluginWidgetImplMac& operator=(const WebNPPluginWidgetImplMac&);
    WebNPPluginWidgetImplMac(const WebNPPluginWidgetImplMac&);
    WebCore::PluginView* const m_ownerPluginView;
    WebCore::IScrollViewApolloImpl* const m_parentScrollViewImpl;
    WebViewImpl* m_webView;
};

}

#endif

