/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "WebNPPluginWidgetImplMac.h"
#include "WebViewImpl.h"
#include "PlatformKeyboardEvent.h"
#include "KeyboardEvent.h"
#include "../../../../WebCore/plugins/PluginView.h"
#include "IScrollViewApolloImpl.h"

namespace WebKitApollo 
{
    WebNPPluginWidgetImplMac::WebNPPluginWidgetImplMac(WebCore::PluginView* ownerPluginView
                                                      , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                                                      , WebViewImpl* const webView)
        : WebPluginWidgetImpl(webView)
        , m_ownerPluginView(ownerPluginView)
        , m_parentScrollViewImpl(parentScrollViewImpl)
        , m_webView(webView)
    {
        ASSERT(m_ownerPluginView);
        ASSERT(m_parentScrollViewImpl);
    }

    WebNPPluginWidgetImplMac::~WebNPPluginWidgetImplMac()
    {
    }

    WTF::PassRefPtr<WebNPPluginWidgetImplMac> WebNPPluginWidgetImplMac::construct(WebCore::PluginView* ownerPluginView
                                                                                 , WebCore::IScrollViewApolloImpl* const parentScrollViewImpl
                                                                                 , WebViewImpl* const webView)
    {
        ASSERT(ownerPluginView);
        ASSERT(parentScrollViewImpl);
        ASSERT(webView);
        return WTF::adoptRef(new WebNPPluginWidgetImplMac(ownerPluginView, parentScrollViewImpl, webView));
    }

    PassRefPtr<KJS::Bindings::Instance> WebNPPluginWidgetImplMac::getInstance(WebCore::Frame*)
    {
        return m_ownerPluginView->bindingInstance();
    }

    void* WebNPPluginWidgetImplMac::createPluginScriptableObject()
    {
        return 0;
    }

    void WebNPPluginWidgetImplMac::releasePluginScriptableObject(void*)
    {
    }

    bool WebNPPluginWidgetImplMac::handleMousePressEvent(const WebCore::PlatformMouseEvent& mouseEvent)
    {
        return false;
    }

    bool WebNPPluginWidgetImplMac::handleMouseMoveEvent(const WebCore::PlatformMouseEvent& mouseEvent)
    {
        return false;
    }

    bool WebNPPluginWidgetImplMac::handleMouseReleaseEvent(const WebCore::PlatformMouseEvent& mouseEvent)
    {
        return false;
    }

    bool WebNPPluginWidgetImplMac::handleWheelEvent(WebCore::PlatformWheelEvent& wheelEvent)
    {
        return false;
    }

    bool WebNPPluginWidgetImplMac::handleKeyboardEvent( const WebCore::PlatformKeyboardEvent& keyEvent )
    {
        ASSERT(m_ownerPluginView);
        WebCore::KeyboardEvent kbEvent(keyEvent, 0);
        m_ownerPluginView->handleKeyboardEvent(&kbEvent);
        return true;
    }

    bool WebNPPluginWidgetImplMac::handleInsertText(const WebCore::String& text)
    {
        ASSERT(m_ownerPluginView);
        return m_ownerPluginView->handleInsertText(text);
    }

    bool WebNPPluginWidgetImplMac::handleCut()
    {
        ASSERT(m_ownerPluginView);
        
        WebCore::PlatformKeyboardEvent const keyEvent(WebCore::PlatformKeyboardEvent::RawKeyDown, 'x', 88, false, false, false, true, false);
        WebCore::KeyboardEvent kbEvent(keyEvent, 0);
        m_ownerPluginView->handleKeyboardEvent(&kbEvent);
        
        return true;
    }

    bool WebNPPluginWidgetImplMac::handleCopy()
    {
        ASSERT(m_ownerPluginView);
        
        WebCore::PlatformKeyboardEvent const keyEvent(WebCore::PlatformKeyboardEvent::RawKeyDown, 'c', 67, false, false, false, true, false);
        WebCore::KeyboardEvent kbEvent(keyEvent, 0);
        m_ownerPluginView->handleKeyboardEvent(&kbEvent);
        
        return true;
    }

    bool WebNPPluginWidgetImplMac::handlePaste()
    {
        ASSERT(m_ownerPluginView);
        
        WebCore::PlatformKeyboardEvent const keyEvent(WebCore::PlatformKeyboardEvent::RawKeyDown, 'v', 86, false, false, false, true, false);
        WebCore::KeyboardEvent kbEvent(keyEvent, 0);
        m_ownerPluginView->handleKeyboardEvent(&kbEvent);
        
        return true;
    }

    bool WebNPPluginWidgetImplMac::handleSelectAll()
    {
        ASSERT(m_ownerPluginView);
        
        WebCore::PlatformKeyboardEvent const keyEvent(WebCore::PlatformKeyboardEvent::RawKeyDown, 'a', 65, false, false, false, true, false);
        WebCore::KeyboardEvent kbEvent(keyEvent, 0);
        m_ownerPluginView->handleKeyboardEvent(&kbEvent);
        
        return true;
    }

    void WebNPPluginWidgetImplMac::setParent(WebCore::IScrollViewApolloImpl* parentScrollViewImpl)
    {
        ASSERT((parentScrollViewImpl == m_parentScrollViewImpl) || (!parentScrollViewImpl));
        WebWidgetImpl::setParent(parentScrollViewImpl);
        if (parentScrollViewImpl)
            m_ownerPluginView->init();
        else
            m_webView->deactivateIMEForPlugin();
    }

    void WebNPPluginWidgetImplMac::paint(WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect)
    {
        ASSERT(false);
        // We should never get here because we override Widget::paint on the PluginView class.
    }

    void WebNPPluginWidgetImplMac::onFocus()
    {
        ASSERT(m_ownerPluginView);
        m_webView->activateIMEForPlugin();
        m_ownerPluginView->setFocus();
    }

    void WebNPPluginWidgetImplMac::onBlur()
    {
        ASSERT(m_ownerPluginView);
        m_webView->deactivateIMEForPlugin();
        m_ownerPluginView->onBlur();
    }

    bool WebNPPluginWidgetImplMac::widgetNeedsMouseDownFromEventHandler() const
    {
        return true;
    }

    WebCore::ResourceHandleClient* WebNPPluginWidgetImplMac::pluginRedirectClient()
    {
        return this;
    }

    void WebNPPluginWidgetImplMac::updatePluginWindow(bool showPlugins, bool showWindowedPlugins)
    {
        m_ownerPluginView->enableOrSuppress(showPlugins);
    }

    WebCore::Widget* WebNPPluginWidgetImplMac::getWidget()
    {
        ASSERT(m_ownerPluginView);
        return m_ownerPluginView;
    }

    void WebNPPluginWidgetImplMac::didReceiveResponse(WebCore::ResourceHandle*, const WebCore::ResourceResponse& response) 
    {
        m_ownerPluginView->didReceiveResponse(response);
    }
    
    void WebNPPluginWidgetImplMac::didReceiveData(WebCore::ResourceHandle*, const char* data, int, int lengthReceived) 
    { 
        m_ownerPluginView->didReceiveData(data, lengthReceived);
    }
    
    void WebNPPluginWidgetImplMac::didFinishLoading(WebCore::ResourceHandle*) 
    {
        m_ownerPluginView->didFinishLoading();
    }
    
    void WebNPPluginWidgetImplMac::didFail(WebCore::ResourceHandle*, const WebCore::ResourceError& error) 
    {
        m_ownerPluginView->didFail(error);
    }
}
