/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef WebWindowScrollView_h
#define WebWindowScrollView_h

#include <IScrollViewApolloImpl.h>
#include "WebFrameScrollView.h"
#include "WebWidgetImpl.h"
#include <WebKitApollo/WebWindow.h>

namespace WebCore
{
    class Frame;
}

namespace WebKitApollo
{
    class WebFrameImpl;
    class IFocusManager;
    class WindowScrollViewImpl : public FrameScrollViewImpl
    {
    protected:
        WindowScrollViewImpl( WebWindow* const pApolloWebKitWindow
                            , WebFrameImpl* const pWebFrameOwner
                            , WebCore::FrameView* const owningFrameView
                            , IFocusManager* const pFocusManager
                            , IMouseCaptureManager* const pMouseCaptureManager );
    public:
        static WTF::PassRefPtr<WindowScrollViewImpl> construct( WebWindow* const pWebWindow
                                                              , WebFrameImpl* const pWebFrameOwner
                                                              , WebCore::FrameView* const owningFrameView
                                                              , IFocusManager* const pFocusManager
                                                              , IMouseCaptureManager* const pMouseCaptureManager);


        //call method with true to suppress drawing of scroll bars on the root frame.
        bool hostDrawsScrollbars() { return m_hostDrawsScrollbars; }
        void setHostDrawsScrollbars(bool);

        // Widget methods
        
        virtual void paint(WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect);
        virtual void invalidateRect(const WebCore::IntRect& dirtyRect);
        
        virtual WebCore::IntRect frameGeometry() const;
        virtual void setFrameGeometry(const WebCore::IntRect &rect);
        
        virtual void setCursor(const WebCore::Cursor&);

        virtual void removeFromParent();
        
        // End Widget methods
        
        virtual WebCore::IntRect windowClipRect() const;
        
        virtual int visibleWidth() const;
        virtual int visibleHeight() const;
        virtual int contentsWidth() const;
        virtual int contentsHeight() const;
        virtual int contentsX() const;
        virtual int contentsY() const;
        virtual WebCore::IntSize scrollOffset() const;
        virtual bool scrollBy(int dx, int dy);
        virtual void scrollRectIntoViewRecursively(const WebCore::IntRect &);
        
        virtual void setContentsPos(int x, int y);

        virtual void setVScrollbarMode(WebCore::ScrollbarMode);
        virtual void setHScrollbarMode(WebCore::ScrollbarMode);

        virtual void suppressScrollbars(bool suppressed, bool repaintOnUnsuppress );
        
        virtual WebCore::ScrollbarMode getVScrollbarMode() const;
        virtual WebCore::ScrollbarMode getHScrollbarMode() const;

        virtual void resizeContents(int w, int h);

        virtual WebCore::IntPoint contentsToViewport(const WebCore::IntPoint&);
        virtual WebCore::IntPoint viewportToContents(const WebCore::IntPoint&);
        virtual WebCore::IntPoint windowToViewport(const WebCore::IntPoint&);
        virtual WebCore::IntPoint viewportToWindow(const WebCore::IntPoint&, bool htmlWindowCoords = false);

        virtual void setStaticBackground(bool);
		WebPlatformWindow getPlatformWindow();
        virtual bool inWindow() const;

        virtual bool handleMousePressEvent(const WebCore::PlatformMouseEvent& mouseEvent);
        virtual bool handleMouseMoveEvent(const WebCore::PlatformMouseEvent& mouseEvent);
        virtual bool handleMouseReleaseEvent(const WebCore::PlatformMouseEvent& mouseEvent);
        virtual bool handleWheelEvent(WebCore::PlatformWheelEvent& wheelEvent);
        virtual WebCore::PlatformScrollbar* scrollbarUnderMouse(const WebCore::PlatformMouseEvent&);
        virtual WebCore::PlatformScrollbar* getVScrollbar();
        virtual WebCore::PlatformScrollbar* getHScrollbar();
        virtual IScrollViewApolloImpl* getParent();
        virtual WebWindow* getWindow(){ return m_pWebWindow; }
        
        virtual bool isInVisibleViewHierarchy() const;

    private:
        WebCore::IntRect clientRect() const;

        WebWindow* m_pWebWindow;
        WebFrameImpl* m_pWebFrameOwner;
        bool m_hostDrawsScrollbars;
        WebCore::IntRect m_lastKnownClientRect;
    };
}

#endif
