/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef WebWidgetImpl_h
#define WebWidgetImpl_h

#include <IWidgetApolloImpl.h>
#include <Font.h>
#include <PlatformScrollBar.h>
#include <wtf/HashSet.h>
#include <Cursor.h>

namespace WebKitApollo {
    class IFocusManager;
    class IMouseCaptureManager;

    class WebWidgetImpl : virtual public WebCore::IWidgetApolloImpl {
    protected:
        WebWidgetImpl(IFocusManager* const pFocusManager, IMouseCaptureManager* const pMouseCaptureManager);
        virtual ~WebWidgetImpl();
    public:

        virtual void setEnabled(bool);
        virtual bool isEnabled() const;
        
        virtual void invalidateRect(const WebCore::IntRect&);
        
        virtual WebCore::IntRect frameGeometry() const;
        virtual void setFrameGeometry(const WebCore::IntRect &rect);
        
        virtual void setFocus();
        
        virtual void setCursor(const WebCore::Cursor& cursor);
        virtual WebCore::Cursor cursor();
        
        virtual void show();
        virtual void hide();
        
        virtual void setIsSelected( bool bSelected );

        virtual void setClient(WebCore::WidgetClient* pClient);
        virtual WebCore::WidgetClient* client() const;

        virtual bool hasMouseCapture() const;
        virtual void setMouseCapture();
        virtual void releaseMouseCapture();
        
        virtual bool handleCut();
        virtual bool handleCopy();
        virtual bool handlePaste();
        virtual bool handleSelectAll();

        virtual WebCore::IScrollViewApolloImpl* getParent();
        virtual WebWindow *getWindow();

        bool hasFocus() const;
        void clearFocus();
        virtual void setParent(WebCore::IScrollViewApolloImpl*);
        virtual void onFocus();
        virtual void onBlur();
        
        virtual bool isInVisibleViewHierarchy() const;

    protected:
        virtual WebCore::Widget* getWidget() = 0;
    private:
        WebCore::WidgetClient* m_pClient;
        WebCore::IntRect m_FrameGeometry;
        WebCore::Font m_Font;
        IFocusManager* const m_pFocusManager;
        IMouseCaptureManager* const m_pMouseCaptureManager;
        WebCore::Cursor m_cursor;
        WebCore::IScrollViewApolloImpl* m_parent;
    };

    
}

#endif
