/*
 * Copyright (C) 2005, 2006 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
 
#ifndef WebPluginWidgetImpl_h
#define WebPluginWidgetImpl_h

#include "WebWidgetImpl.h"
#include "IPluginWidgetApolloImpl.h"

namespace WebCore {
class ResourceHandleClient;
class IPluginWidgetApolloImpl;
}

namespace WebKitApollo {

class WebViewImpl;

class WebPluginWidgetImpl :	public WebCore::IPluginWidgetApolloImpl, public WebWidgetImpl
{
protected:
    WebPluginWidgetImpl(WebViewImpl* const);
    virtual ~WebPluginWidgetImpl();
    
public:
    virtual void setEnabled(bool);
    virtual bool isEnabled() const;
    
    virtual void invalidateRect(const WebCore::IntRect&);
    
    virtual WebCore::IntRect frameGeometry() const;
    virtual void setFrameGeometry(const WebCore::IntRect &rect);
    
    virtual void setFocus();
    
    virtual void setCursor(const WebCore::Cursor& cursor);
    virtual WebCore::Cursor cursor();
    
    virtual void show();
    virtual void hide();
    
    virtual void setIsSelected( bool bSelected );

    virtual void setClient(WebCore::WidgetClient* pClient);
    virtual WebCore::WidgetClient* client() const;

    virtual bool hasMouseCapture() const;
    virtual void setMouseCapture();
    virtual void releaseMouseCapture();
    
    virtual bool handleCut();
    virtual bool handleCopy();
    virtual bool handlePaste();
    virtual bool handleSelectAll();

    virtual WebCore::IScrollViewApolloImpl* getParent();
    virtual WebWindow *getWindow();

    virtual void setParent(WebCore::IScrollViewApolloImpl*);
    virtual void onFocus();
    virtual void onBlur();
    virtual bool widgetNeedsMouseDownFromEventHandler() const;
    virtual WebCore::ResourceHandleClient* pluginRedirectClient() = 0;
    virtual WTF::PassRefPtr<WebCore::IPluginWidgetApolloImpl> toPluginWidgetImpl();
    virtual void updatePluginWindow(bool showPlugins, bool showWindowedPlugins) = 0;

    virtual bool isInVisibleViewHierarchy() const;
private:
    WebViewImpl* const m_webView;
};

}

#endif

