/*
 * Copyright (C) 2005, 2006 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1.  Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer. 
 * 2.  Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 * 3.  Neither the name of Apple Computer, Inc. ("Apple") nor the names of
 *     its contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE AND ITS CONTRIBUTORS "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL APPLE OR ITS CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "WebPluginWidgetImpl.h"
#include "WebViewImpl.h"


namespace WebKitApollo {

WebPluginWidgetImpl::WebPluginWidgetImpl(WebViewImpl* const webView)
    : WebWidgetImpl(webView->focusManager(), webView->mouseCaptureManager())
    , m_webView(webView)
{
    ASSERT(m_webView);
    m_webView->addPluginImpl(this);
}

WebPluginWidgetImpl::~WebPluginWidgetImpl()
{
    ASSERT(m_webView);
    m_webView->removePluginImpl(this);
}

void WebPluginWidgetImpl::setEnabled(bool enabled)
{
    WebWidgetImpl::setEnabled(enabled);
}

bool WebPluginWidgetImpl::isEnabled() const
{
    return WebWidgetImpl::isEnabled();
}

void WebPluginWidgetImpl::invalidateRect(const WebCore::IntRect& r)
{
    if (getParent())
        WebWidgetImpl::invalidateRect(r);
}

WebCore::IntRect WebPluginWidgetImpl::frameGeometry() const
{
    return WebWidgetImpl::frameGeometry();
}

void WebPluginWidgetImpl::setFrameGeometry(const WebCore::IntRect &rect)
{
    WebWidgetImpl::setFrameGeometry(rect);
}

void WebPluginWidgetImpl::setFocus()
{
    WebWidgetImpl::setFocus();
}

void WebPluginWidgetImpl::setCursor(const WebCore::Cursor& cursor)
{
    WebWidgetImpl::setCursor(cursor);
}

WebCore::Cursor WebPluginWidgetImpl::cursor()
{
    return WebWidgetImpl::cursor();
}

void WebPluginWidgetImpl::setIsSelected( bool bSelected )
{
    WebWidgetImpl::setIsSelected(bSelected);
}

void WebPluginWidgetImpl::setClient(WebCore::WidgetClient* pClient)
{
    WebWidgetImpl::setClient(pClient);
}

WebCore::WidgetClient* WebPluginWidgetImpl::client() const
{
    return WebWidgetImpl::client();
}

bool WebPluginWidgetImpl::hasMouseCapture() const
{
    return WebWidgetImpl::hasMouseCapture();
}

void WebPluginWidgetImpl::setMouseCapture()
{
    WebWidgetImpl::setMouseCapture();
}

void WebPluginWidgetImpl::releaseMouseCapture()
{
    WebWidgetImpl::releaseMouseCapture();
}

bool WebPluginWidgetImpl::handleCut()
{
    return WebWidgetImpl::handleCut();
}

bool WebPluginWidgetImpl::handleCopy()
{
    return WebWidgetImpl::handleCopy();
}

bool WebPluginWidgetImpl::handlePaste()
{
    return WebWidgetImpl::handlePaste();
}

bool WebPluginWidgetImpl::handleSelectAll()
{
    return WebWidgetImpl::handleSelectAll();
}

WebCore::IScrollViewApolloImpl* WebPluginWidgetImpl::getParent()
{
    return WebWidgetImpl::getParent();
}

WebWindow *WebPluginWidgetImpl::getWindow()
{
    return WebWidgetImpl::getWindow();
}

void WebPluginWidgetImpl::setParent(WebCore::IScrollViewApolloImpl* parent)
{
    WebWidgetImpl::setParent(parent);
}

void WebPluginWidgetImpl::onFocus()
{
    WebWidgetImpl::onFocus();
}

void WebPluginWidgetImpl::onBlur()
{
    WebWidgetImpl::onBlur();
}

bool WebPluginWidgetImpl::widgetNeedsMouseDownFromEventHandler() const
{
    // The player currently will send us the click when determining what should get focus
    // and then the NSEvent goes to the PDF NSView.  If the player disables sending the event
    // to the NSView, we may need to start forwarding the event to the plug-in.  See hack in
    // cocoa_contentwindow.mm : sendEvent
    return false;
}

void WebPluginWidgetImpl::show()
{
}

void WebPluginWidgetImpl::hide()
{
}

WTF::PassRefPtr<WebCore::IPluginWidgetApolloImpl> WebPluginWidgetImpl::toPluginWidgetImpl()
{
    return this;
}

bool WebPluginWidgetImpl::isInVisibleViewHierarchy() const
{
    return WebWidgetImpl::isInVisibleViewHierarchy();
}

}
