/*
 *  WebPluginWidget.h
 *  WebKit
 *
 *  Created by Christopher Brichford on 5/4/07.
 *  Copyright 2007 Adobe Systems, Inc. All rights reserved.
 *
 */

#ifndef WebPluginWidget_h
#define WebPluginWidget_h

#include <Widget.h>
#include <wtf/Vector.h>
#include <wtf/PassRefPtr.h>
#include <wtf/RefPtr.h>
#include <memory>

namespace WebCore {
    class KURL;
    class String;
}

namespace WebKitApollo {
    class WebFrameImpl;
    class PluginImpl;
    class WebPluginWidget : public WebCore::Widget
    {
    public:
        static std::auto_ptr<WebPluginWidget> construct(WTF::PassRefPtr<PluginImpl> pluginWidgetImpl);
        virtual ~WebPluginWidget();
    private:
        WebPluginWidget(WTF::PassRefPtr<PluginImpl> pluginWidgetImpl);
    };
}

#endif
