/*
 *  WebPluginWidget.cpp
 *  WebKit
 *
 *  Created by Christopher Brichford on 5/4/07.
 *  Copyright 2007 Adobe Systems, Inc. All rights reserved.
 *
 */

#include "WebPluginWidget.h"
#include "WebPluginImpl.h"

namespace WebKitApollo {
std::auto_ptr<WebPluginWidget> WebPluginWidget::construct(WTF::PassRefPtr<PluginImpl> pluginWidgetImpl)
{
    std::auto_ptr<WebPluginWidget> result(new WebPluginWidget(pluginWidgetImpl));
    return result;
}

WebPluginWidget::~WebPluginWidget()
{
}

WebPluginWidget::WebPluginWidget(WTF::PassRefPtr<PluginImpl> pluginWidgetImpl)
{
    pluginWidgetImpl->setWidget(this);
    attachApolloImpl(pluginWidgetImpl);
}

}
