#ifndef WEB_PLUGIN_WK_H
#define WEB_PLUGIN_WK_H

#include "WebPluginImpl.h"

//This is the base WebKit Plugin class

namespace WebKitApollo
{
	class PluginWK : public PluginImpl
	{
	protected:
		PluginWK(	WebCore::Element *element,
					const WebCore::KURL& url,
					const Vector<WebCore::String>& paramNames, 
					const Vector<WebCore::String>& paramValues,
					const WebCore::String& mimeType,
					WebFrameImpl* const pWebFrameOwner );
		virtual ~PluginWK();

	public:
		static WTF::PassRefPtr< PluginImpl > construct(	WebCore::Element * const element,
													const WebCore::KURL& url,
													const Vector<WebCore::String>& paramNames, 
													const Vector<WebCore::String>& paramValues,
													const WebCore::String& mimeType,
													WebFrameImpl* const pWebFrameOwner );

        virtual WTF::PassRefPtr<KJS::Bindings::Instance> getInstance(WebCore::Frame *frame );
	};
}

#endif
