#include "WebPluginWK.h"
#include "WebPluginNP.h"
#include "WebPluginPDFImplMac.h"
#include "PlugInInfoStore.h"
#include "kjs_proxy.h"
#include "runtime_root.h"
#include "objc/objc_instance.h"

namespace WebKitApollo
{
	PluginWK::PluginWK(	WebCore::Element* element,
									const WebCore::KURL& url,
									const Vector<WebCore::String>& paramNames, 
									const Vector<WebCore::String>& paramValues,
									const WebCore::String& mimeType,
									WebFrameImpl* const pWebFrameOwner )
		:	PluginImpl(element, url, paramNames, paramValues, mimeType, pWebFrameOwner)
	{
	}

	PluginWK::~PluginWK()
	{
	}

	WTF::PassRefPtr< PluginImpl > PluginWK::construct(	WebCore::Element* const element,
													const WebCore::KURL& url,
													const Vector<WebCore::String>& paramNames, 
													const Vector<WebCore::String>& paramValues,
													const WebCore::String& mimeType,
													WebFrameImpl* const pWebFrameOwner )
	{
		//Depending on the mimetype, we create different client implementations
		if ( WebCore::PluginInfoStore::isPDFMIMEType( mimeType ) )
		{
			#if PLATFORM(DARWIN)
				return WTF::adoptRef< PluginImpl >( new PluginPDFImplMac( element, url, paramNames, paramValues, mimeType, pWebFrameOwner ) );
			#else
				//pdf webkit plug-ins on other platforms would go here
				assert( false );
				return WTF::adoptRef< PluginImpl >( new PluginWK( element, url, paramNames, paramValues, pWebFrameOwner ) );
			#endif
		}
		else
		{	//other webkit plugin mimetypes would go here
			assert( false );
			return 0;
		}
	}

    WTF::PassRefPtr<KJS::Bindings::Instance> PluginWK::getInstance(WebCore::Frame *frame )
    {
        void *object = createPluginScriptableObject();

        if (object) {
            // The root gets deleted by JavaScriptCore.
            RefPtr<KJS::Bindings::RootObject> root = frame->createRootObject(this, frame->scriptProxy()->globalObject());
            WebFrameImpl::kit(frame)->addPluginRootObject(root);

            RefPtr<KJS::Bindings::Instance> instance = KJS::Bindings::ObjcInstance::create((objc_object*)object, root.release());
            
            // -createPluginScriptableObject returns a retained NPObject.  The caller is expected to release it.
            releasePluginScriptableObject(object);
            
            return instance.release();
        }

        return 0;
    }
}
