#include "WebPluginPDFImpl.h"

#if PLATFORM(DARWIN)
#include "WebPluginPDFImplMac.h"
#elif PLATFORM(WIN_OS)
#include "win/WebPluginPDFImplWin.h"
#elif PLATFORM(UNIX_OS)
#include "unix/WebPluginPDFImplUnix.h"
#endif

namespace WebKitApollo
{
    PluginPDFImpl::PluginPDFImpl(  WebCore::Element* element,
                                   const WebCore::KURL& url,
                                   const Vector<WebCore::String>& paramNames, 
                                   const Vector<WebCore::String>& paramValues,
                                   const WebCore::String& mimeType,
                                   WebFrameImpl* const pWebFrameOwner )
        :    PluginImpl(element, url, paramNames, paramValues, mimeType, pWebFrameOwner)
    {
    }

    PluginPDFImpl::~PluginPDFImpl()
    {
    }

    WTF::RefPtr< PluginImpl > PluginPDFImpl::construct( WebCore::Element* const element,
                                                        const WebCore::KURL& url,
                                                        const Vector<WebCore::String>& paramNames, 
                                                        const Vector<WebCore::String>& paramValues,
                                                        const WebCore::String& mimeType,
                                                        WebFrameImpl* const pWebFrameOwner )
    {
#if PLATFORM(DARWIN)
        return WTF::RefPtr< PluginImpl >( new PluginPDFImplMac( element, url, paramNames, paramValues, mimeType, pWebFrameOwner ) );
#elif PLATFORM(WIN_OS)
        return WTF::RefPtr< PluginImpl >( new PluginPDFImplWin( element, url, paramNames, paramValues, mimeType, pWebFrameOwner ) );
#elif PLATFORM(UNIX_OS)
        return WTF::RefPtr< PluginImpl >( new PluginPDFImplUnix( element, url, paramNames, paramValues, mimeType, pWebFrameOwner ) );
#else
        assert( false );
        return NULL;
#endif
    }


}
