#include "WebPluginNP.h"

#if PLATFORM(WIN_OS)
#include "win/WebPluginPDFImplWin.h"
#elif PLATFORM(UNIX_OS)
#include "unix/WebPluginPDFImplUnix.h"
#endif

#include "PluginInfoStore.h"
#include <kjs_proxy.h>
#include "c/c_instance.h"

namespace WebKitApollo
{
    PluginNP::PluginNP( WebCore::Element* element,
                        const WebCore::KURL& url,
                        const Vector<WebCore::String>& paramNames, 
                        const Vector<WebCore::String>& paramValues,
                        const WebCore::String& mimeType,
                        WebFrameImpl* const pWebFrameOwner )
        :    PluginImpl(element, url, paramNames, paramValues, mimeType, pWebFrameOwner)
    {
    }

    PluginNP::~PluginNP()
    {
    }

    WTF::PassRefPtr< PluginImpl > PluginNP::construct(  WebCore::Element* const element,
                                                    const WebCore::KURL& url,
                                                    const Vector<WebCore::String>& paramNames, 
                                                    const Vector<WebCore::String>& paramValues,
                                                    const WebCore::String& mimeType,
                                                    WebFrameImpl* const pWebFrameOwner )
    {
        //Depending on the mimetype, we create different client implementations
        if ( WebCore::PluginInfoStore::isPDFMIMEType( mimeType ) )
        {
            #if PLATFORM(WIN_OS)
                if(PluginPDFImplWin::PluginExists())
                    return WTF::adoptRef< PluginImpl >( new PluginPDFImplWin( element, url, paramNames, paramValues, mimeType, pWebFrameOwner ) );
                else return NULL;
            #elif PLATFORM(UNIX_OS)
                if(PluginPDFImplUnix::PluginExists())
                    return WTF::adoptRef< PluginImpl >( new PluginPDFImplUnix( element, url, paramNames, paramValues, mimeType, pWebFrameOwner ) );
                else return NULL;
            #else
                //pdf netscape plug-ins on other platforms would go here
                assert( false );
                return WTF::adoptRef< PluginImpl >( new PluginNP( element, url, paramNames, paramValues, mimeType, pWebFrameOwner ) );
            #endif
        }

        //other mimetypes would go here
        ASSERT( false );
        return 0;
    }

    WTF::PassRefPtr<KJS::Bindings::Instance> PluginNP::getInstance(WebCore::Frame *frame )
    {
        void *object = createPluginScriptableObject();

        if (object) {
            // The root gets deleted by JavaScriptCore.
            RefPtr<KJS::Bindings::RootObject> root = frame->createRootObject(this, frame->scriptProxy()->globalObject());
            WebFrameImpl::kit(frame)->addPluginRootObject(root);

            RefPtr<KJS::Bindings::Instance> instance = KJS::Bindings::CInstance::create((NPObject *)object, root.release());
            
            // -createPluginScriptableObject returns a retained NPObject.  The caller is expected to release it.
            releasePluginScriptableObject(object);
            
            return instance.release();
        }

        return 0;
    }
}

