#ifndef APOLLO_WEBKIT_PLUGIN_IMPL_H
#define APOLLO_WEBKIT_PLUGIN_IMPL_H

#include "WebWidgetImpl.h"
#include "WebFrameImpl.h"
#include "ResourceHandle.h"
#include "WebPluginWidget.h"
#include "WebPluginWidgetImpl.h"

//This is the base Plugin class; subclass this based on mimetype,
//and use construct factor for platform-based class

namespace WebKitApollo
{
	class PluginImpl : public WebPluginWidgetImpl, protected WebCore::ResourceHandleClient
	{
        friend class WebPluginWidget;
        friend class WTF::RefPtr<PluginImpl>;
        friend class WTF::PassRefPtr<PluginImpl>;
	protected:
		PluginImpl(	WebCore::Element *element,
					const WebCore::KURL& url,
					const Vector<WebCore::String>& paramNames, 
					const Vector<WebCore::String>& paramValues,
					const WebCore::String& mimeType,
					WebFrameImpl* const pWebFrameOwner );
		virtual ~PluginImpl();

	public:
		static WTF::PassRefPtr< PluginImpl > construct(	WebCore::Element * const element,
													const WebCore::KURL& url,
													const Vector<WebCore::String>& paramNames, 
													const Vector<WebCore::String>& paramValues,
													const WebCore::String& mimeType,
													WebFrameImpl* const pWebFrameOwner );

		//Not un-abstracted by superclass
		virtual void setCursor( const WebCore::Cursor& cursor );
        virtual void removeFromParent();

		virtual void paint( WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect );

		virtual void setFrameGeometry(const WebCore::IntRect &rect);

        virtual void* createPluginScriptableObject();
        virtual void releasePluginScriptableObject(void* object);

		virtual bool handleMousePressEvent( const WebCore::PlatformMouseEvent& mouseEvent );
		virtual bool handleMouseMoveEvent( const WebCore::PlatformMouseEvent& mouseEvent );
		virtual bool handleMouseReleaseEvent( const WebCore::PlatformMouseEvent& mouseEvent );
		virtual bool handleWheelEvent( WebCore::PlatformWheelEvent& wheelEvent );
		virtual bool handleKeyboardEvent( const WebCore::PlatformKeyboardEvent& keyEvent );
        virtual bool handleInsertText(const WebCore::String& text);
		virtual bool hasFocus() const;
		virtual void setFocus();
		virtual void clearFocus();
		
		void beginModal() const;
		void endModal() const;

		virtual bool isEnabled() const;
		
		WebCore::IntPoint contentsToWindow( const WebCore::IntPoint& contentsPoint ) const;
        
        virtual WebCore::ResourceHandleClient* pluginRedirectClient();

	protected:
        virtual WebCore::Widget* getWidget();
        void setWidget(WebCore::Widget*);
		virtual void frameGeometryHasChanged( const WebCore::IntRect &oldRect, const WebCore::IntRect& windowRect, const WebCore::IntRect& windowClipRect ) {};
	public:
		const WebCore::Element* getElement() const { return mElement; };
		const WebCore::KURL& getUrl() const { return mURL; };
		const WebCore::String& getMimeType() const { return mMimeType; };
		WebFrameImpl* const getWebFrameOwner() const { return mWebFrameOwner; };

	public:
		//Convenience funtions for command requests from resource loading
		unsigned long resourceResponseContentLength( const WebCore::ResourceResponse& resourceResponse );

		bool allowURLRequest( const WebCore::KURL sourceURL, const WebCore::KURL requestedURL, WebCore::Frame *targetFrame );
		bool allowURLRequest( const WebCore::KURL requestedURL, WebCore::Frame *target );

	protected:

		// Resouce-loading utilities
		void loadURLForClient( const WebCore::KURL& urlToLoad, void *client );
		void loadURLForClient(	const WebCore::KURL& urlToLoad, const char *method,
								const char *data, unsigned int dataLength,
								void *client,
								const WebCore::HTTPHeaderMap& headerMap,
								WebCore::Frame *frame = NULL );
	protected:
	//	Overrides of WebCore::ResourceHandleClient.  Subclasses will not override these;
	//	instead they'll override the next set.  This base class will map these callbacks
	//	to the client passed in by the subclass.

        virtual void willSendRequest(WebCore::ResourceHandle*, WebCore::ResourceRequest&, const WebCore::ResourceResponse& redirectResponse);
        virtual void didReceiveResponse(WebCore::ResourceHandle*, const WebCore::ResourceResponse&);
        virtual void didReceiveData(WebCore::ResourceHandle*, const char*, int, int lengthReceived);
        virtual void didFinishLoading(WebCore::ResourceHandle*);

        // XXX - void receivedAllData(WebCore::ResourceHandle* resourceHandle, WebCore::PlatformData platformData);
		
	//	This is the mapping from the client passed to loadURLForClient to the 
	//	ResourceHandle created for that.  The method is a bottleneck to allow
	//	us to catch when there is no client.
    private:
        HashMap<RefPtr<WebCore::ResourceHandle>, void *> mResourceHandleClientMap;
    protected:
		void *clientFromHandle(RefPtr<WebCore::ResourceHandle> resourceHandle ) { return mResourceHandleClientMap.get(resourceHandle); }
		void clearClientHandle(RefPtr<WebCore::ResourceHandle> resourceHandle) { mResourceHandleClientMap.remove(resourceHandle); }

	// This is a mapping from the other way to allow us to get a loader from a client.
    private:
		HashMap<void *, RefPtr<WebCore::ResourceHandle> > mClientResourceHandleMap;
    protected:
		RefPtr<WebCore::ResourceHandle> handleFromClient(void * client) { return mClientResourceHandleMap.get(client); }
		void clearHandleFromClient(void* client) { mClientResourceHandleMap.remove(client); }


	public:
	//	Subclasses should override these.  The first parameter is the client parameter
	//	passed to loadURLForClient.  These are not pure virtual because in the case that
	//	we don't understand a mime type, we allocate this base class.
        virtual void clientReceivedRedirect(void *client, WebCore::ResourceHandle*, const WebCore::KURL&) {};
        virtual void clientReceivedResponse(void *client, WebCore::ResourceHandle*, const WebCore::ResourceResponse&) {};
        virtual void clientReceivedData(void *client, WebCore::ResourceHandle*, const char* data, int length) {};
        virtual void clientReceivedAllData(void *client, WebCore::ResourceHandle*) {};
        // XXX - virtual void clientReceivedAllData(void *client, WebCore::ResourceHandle*, WebCore::PlatformData) {};

	protected:
		bool				mHasFocus;
		//WebCore::IntRect	m_FrameGeometry;
		WebCore::IntRect	mWindowRect;
		WebCore::IntRect	mClippedWindowRect;
		WebCore::IntRect	mClippedFrameWindowRect;

		WebFrameImpl* const mWebFrameOwner;
        WebCore::Element*	mElement;
		WebCore::KURL		mURL;
		WebCore::String		mMimeType;

		Vector<WebCore::String> mParamNames;
		Vector<WebCore::String> mParamValues;

		WTF::RefPtr<WebCore::EventListener> mEventListener;
		WTF::RefPtr<WebCore::Document>		mEventListenerDocument;
        WebCore::Widget*                    mOwningWidget;
	};
}

#endif
