/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef WebFrameScrollView_h
#define WebFrameScrollView_h

#include <IScrollViewApolloImpl.h>
#include <WebNonPluginWidgetImpl.h>
#include <WebKitApollo/WebWindow.h>
#include <WebKitApollo/WebResourceHandle.h>

namespace WebCore
{
	class Frame;
	class PlatformMouseEvent;
	class PlatformKeyboardEvent;
}

namespace WebKitApollo
{
	class WebFrameImpl;
	class IFocusManager;
	class IMouseCaptureManager;

	class FrameScrollViewImpl :	public WebCore::IScrollViewApolloImpl, public WebNonPluginWidgetImpl, private WebCore::ScrollbarClient
	{
	protected:
		FrameScrollViewImpl( WebFrameImpl* const pWebFrameOwner
                           , WebCore::FrameView* const owningFrameView
                           , IFocusManager* const pFocusManager,
                             IMouseCaptureManager* const pMouseCaptureManager);
		virtual ~FrameScrollViewImpl();
		void paintImpl(WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& widgetDirtyRect);
		virtual WebCore::IntRect clientRect() const = 0;
		void updateScrollbars();
        bool isOwningWebFrameAlive() const { return m_webFrameOwnerAlive; }
	public:

        void owningWebFrameIsDead();

		//==================
		virtual int visibleWidth() const;
        virtual int visibleHeight() const;
        virtual int contentsWidth() const;
        virtual int contentsHeight() const;
        virtual int contentsX() const;
        virtual int contentsY() const;
        virtual WebCore::IntSize scrollOffset() const;
        virtual bool scrollBy(int dx, int dy);
		
        virtual void setContentsPos(int x, int y);

        virtual void setVScrollbarMode(WebCore::ScrollbarMode);
        virtual void setHScrollbarMode(WebCore::ScrollbarMode);

        virtual void suppressScrollbars(bool suppressed, bool repaintOnUnsuppress );
        
        virtual WebCore::ScrollbarMode getVScrollbarMode() const;
        virtual WebCore::ScrollbarMode getHScrollbarMode() const;

        virtual void resizeContents(int w, int h);
        virtual void updateContents(const WebCore::IntRect&, bool now = false);

        virtual WebCore::IntPoint contentsToViewport(const WebCore::IntPoint&);
        virtual WebCore::IntPoint viewportToContents(const WebCore::IntPoint&);

        virtual void setStaticBackground(bool);
		WebPlatformWindow getPlatformWindow();
		virtual bool inWindow() const;

        virtual void setEnabled(bool bEnabled);
		virtual bool isEnabled() const;
		
        virtual void paint(WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect) = 0;
        virtual void invalidateRect(const WebCore::IntRect&);
        
		virtual WebCore::IntRect frameGeometry() const;
        virtual void setFrameGeometry(const WebCore::IntRect &rect);
        
        virtual void setFocus();

        virtual void setCursor(const WebCore::Cursor& cursor);
        virtual WebCore::Cursor cursor();

		virtual void show();
		virtual void hide();

        virtual void setIsSelected(bool bSelected);

		virtual void setClient(WebCore::WidgetClient* pClient);
		virtual WebCore::WidgetClient* client() const;

        virtual WebCore::IScrollViewApolloImpl* getParent();

        virtual bool hasMouseCapture() const;
        virtual void setMouseCapture();
        virtual void releaseMouseCapture();

        virtual PassRefPtr<KJS::Bindings::Instance> getInstance(WebCore::Frame*);
        virtual void* createPluginScriptableObject();
        virtual void releasePluginScriptableObject(void*);

		virtual bool handleMousePressEvent(const WebCore::PlatformMouseEvent& mouseEvent);
		virtual bool handleMouseMoveEvent(const WebCore::PlatformMouseEvent& mouseEvent);
		virtual bool handleMouseReleaseEvent(const WebCore::PlatformMouseEvent& mouseEvent);
        virtual bool handleWheelEvent(WebCore::PlatformWheelEvent& wheelEvent);

		virtual bool handleKeyboardEvent( const WebCore::PlatformKeyboardEvent& keyEvent);
        virtual bool handleInsertText(const WebCore::String& text);
        virtual bool handleCut();
        virtual bool handleCopy();
        virtual bool handlePaste();
        virtual bool handleSelectAll();
        virtual WebCore::PlatformScrollbar* scrollbarUnderMouse(const WebCore::PlatformMouseEvent&);
        virtual WebCore::PlatformScrollbar* getVScrollbar();
        virtual WebCore::PlatformScrollbar* getHScrollbar();

        virtual void scrollbarIsDirty(WebCore::Scrollbar*);
        
        virtual WebWindow *getWindow();
        virtual void setParent(WebCore::IScrollViewApolloImpl*);
        virtual void onFocus();
        virtual void onBlur();
        virtual bool widgetNeedsMouseDownFromEventHandler() const;

        virtual WTF::PassRefPtr<WebCore::IPluginWidgetApolloImpl> toPluginWidgetImpl();
        virtual bool isInVisibleViewHierarchy() const;
        virtual bool isActive() const;
        virtual WebCore::ScrollView* scrollView() const;

	protected:
        virtual WebCore::Widget* getWidget();
        WebCore::Frame* frame() const;
        WebCore::FrameView* frameView() const;
		WebFrameImpl* const m_pWebFrameOwner;
        bool m_webFrameOwnerAlive;
		bool m_isSendingScrollEvent;
	private:

		virtual void valueChanged(WebCore::Scrollbar* pChangedScrollbar);

		static WebCore::PlatformMouseEvent transformMouseEvent(const WebCore::IntPoint& newOrigin, const WebCore::PlatformMouseEvent& mouseEvent);
		
		WebCore::IntSize maximumScroll() const;

		enum HitTestResult {
			kHitTestResultContent,
			kHitTestResultHScrollbar,
			kHitTestResultVScrollbar,
			//----------- New values go above this comment ----------
			kHitTestResultLast
		};

		HitTestResult hitTest(const WebCore::IntPoint& point);
	
		
		WebCore::IntSize m_contentsSize;
		WebCore::IntSize m_scrollOffset;
		WebCore::ScrollbarMode m_vScrollbarMode;
		WebCore::ScrollbarMode m_hScrollbarMode;
		bool m_suppressScrollbars;
		bool m_staticBackground;
		WTF::RefPtr<WebCore::PlatformScrollbar> m_hScrollbar;
		WTF::RefPtr<WebCore::PlatformScrollbar> m_vScrollbar;
		bool m_showHScrollbar;
		bool m_showVScrollbar;
        WebCore::FrameView* const m_owningFrameView;
	};

	class SubFrameScrollViewImpl : public FrameScrollViewImpl
	{
	protected:
		SubFrameScrollViewImpl(	WebFrameImpl* const pWebFrameOwner
                              , WebCore::FrameView* const owningFrameView
                              , IFocusManager* const pFocusManager
                              , IMouseCaptureManager* const pMouseCaptureManager);
		virtual ~SubFrameScrollViewImpl();
		virtual WebCore::IntRect clientRect() const;

	public:
		static WTF::PassRefPtr<SubFrameScrollViewImpl>
			construct( WebFrameImpl* const pWebFrameOwner
                     , WebCore::FrameView* const owningFrameView
                     , IFocusManager* const pFocusManager
                     , IMouseCaptureManager* const pMouseCaptureManager);
        virtual void scrollRectIntoViewRecursively(const WebCore::IntRect&);

		virtual WebCore::IntPoint windowToViewport(const WebCore::IntPoint&);
		virtual WebCore::IntPoint viewportToWindow(const WebCore::IntPoint&, bool htmlWindowCoords = false);

		virtual void setFrameGeometry(const WebCore::IntRect &rect);

		virtual void paint(WebCore::GraphicsContext* pGraphicsContext, const WebCore::IntRect& dirtyRect);
        virtual WebCore::IntRect windowClipRect()const;
        virtual void setParent(IScrollViewApolloImpl*);
	};
}

#endif
