/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef WebView_h
#define WebView_h

#include <WebKitApollo/WebConfig.h>

struct WebView;
struct WebHost;
struct WebError;
struct WebWindow;
struct WebFrame;
struct WebIntRect;
class WebMenuItem;
struct WebString;

enum WebMouseButton {
    WebMouseButtonLeft = 0,
    WebMouseButtonMiddle,
    WebMouseButtonRight,

    /*-----------------------------------------
      Add new enum values above this comment!!
    -------------------------------------------*/
    WebMouseButtonLast
};

/* on mac bool is defined in stdbool.h as: #define bool bool */
#ifdef bool
#undef bool
#endif

#define bool DO_NO_USE_BOOLS_IN_THIS_FILE

typedef WEBKIT_APOLLO_PROTO1 WebView* ( WEBKIT_APOLLO_PROTO2 *WebViewCreateFunction )( WebHost* pWebHost
                                                                                     , WebWindow* pTargetWindow
                                                                                     , WebError* pErrorInfo );

typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewDestroyFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 WebFrame* ( WEBKIT_APOLLO_PROTO2 *WebViewMainFrameFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewLayoutFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewPaintFunction )( WebView* pWebView
                                                                                , const WebIntRect* pPaintRect );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewOnContextMenuItemSelectFunction )( WebView* pWebView, int const actionID, const uint16_t *title);
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnContextMenuFunction )( WebView* pWebView
                                                                                      , int const localX
                                                                                      , int const localY
                                                                                      , int const screenX
                                                                                      , int const screenY
                                          											  , unsigned char const shiftKey
                                                                                      , unsigned char const ctrlKey
                                                                                      , unsigned char const altKey
                                                                                      , unsigned char const metaKey );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnMouseDownFunction )( WebView* pWebView
                                                                                      , int const localX
                                                                                      , int const localY
                                                                                      , int const screenX
                                                                                      , int const screenY
                                                                                      , WebMouseButton const mouseButton
                                                                                      , unsigned int const clickCount
                                                                                      , unsigned char const shiftKey
                                                                                      , unsigned char const ctrlKey
                                                                                      , unsigned char const altKey
                                                                                      , unsigned char const metaKey );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnMouseUpFunction )( WebView* pWebView
                                                                                    , int const localX
                                                                                    , int const localY
                                                                                    , int const screenX
                                                                                    , int const screenY
                                                                                    , WebMouseButton const mouseButton
                                                                                    , unsigned int const clickCount
                                                                                    , unsigned char const shiftKey
                                                                                    , unsigned char const ctrlKey
                                                                                    , unsigned char const altKey
                                                                                    , unsigned char const metaKey );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnMouseMoveFunction )( WebView* pWebView
                                                                                      , int const localX
                                                                                      , int const localY
                                                                                      , int const screenX
                                                                                      , int const screenY
                                                                                      , unsigned char const shiftKey
                                                                                      , unsigned char const ctrlKey
                                                                                      , unsigned char const altKey
                                                                                      , unsigned char const metaKey
                                                                                      , unsigned char const buttonDown);
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnMouseWheelFunction )( WebView* pWebView
                                                                                      , int const localX
                                                                                      , int const localY
                                                                                      , int const screenX
                                                                                      , int const screenY
                                                                                      , int const deltaX
                                                                                      , int const deltaY
                                                                                      , unsigned char const shiftKey
                                                                                      , unsigned char const ctrlKey
                                                                                      , unsigned char const altKey
                                                                                      , unsigned char const metaKey );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewOnFocusInFunction )( WebView* pWebView, const uint16_t *direction, int length );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewOnFocusOutFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewOnWindowActivateFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewOnWindowDeactivateFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnKeyDownFunction )( WebView* pWebView
                                                                                             , unsigned int const winCharCode
                                                                                             , unsigned int const winKeyCode
                                                                                             , unsigned char const isShiftKey
                                                                                             , unsigned char const isCtrlKey
                                                                                             , unsigned char const isAltKey
                                                                                             , unsigned char const metaKey
                                                                                             , unsigned char const isAutoRepeat );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnKeyUpFunction )( WebView* pWebView
                                                                                           , unsigned int const winCharCode
                                                                                           , unsigned int const winKeyCode
                                                                                           , unsigned char const isShiftKey
                                                                                           , unsigned char const isCtrlKey
                                                                                           , unsigned char const isAltKey
                                                                                           , unsigned char const metaKey );

typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnKeyPressFunction )( WebView* pWebView
                                                                                             , unsigned int const winCharCode
                                                                                             , unsigned char const isShiftKey
                                                                                             , unsigned char const isCtrlKey
                                                                                             , unsigned char const isAltKey
                                                                                             , unsigned char const metaKey
                                                                                             , unsigned char const isAutoRepeat );

typedef WEBKIT_APOLLO_PROTO1 unsigned char (WEBKIT_APOLLO_PROTO2* WebViewInsertTextFunction)(WebView* webView
                                                                                       , const uint16_t* utf16Text
                                                                                       , unsigned long numUTF16CodeUnits);

typedef struct
{
    int start;
    int end;
    struct { uint8_t red, green, blue, alpha; } color;
    unsigned char thick;
} WebViewCompositionUnderlineRange;

typedef WEBKIT_APOLLO_PROTO1 void (WEBKIT_APOLLO_PROTO2* WebViewSetCompositionFunction)( WebView* webView
                                                                                       , const uint16_t* utf16Text
                                                                                       , unsigned long numUTF16CodeUnits
                                                                                       , WebViewCompositionUnderlineRange* underlineRanges
                                                                                       , unsigned long numUnderlineRanges
                                                                                       , int startSelection
                                                                                       , int endSelection );

typedef WEBKIT_APOLLO_PROTO1 void (WEBKIT_APOLLO_PROTO2* WebViewConfirmCompositionFunction)( WebView* webView
                                                                                           , const uint16_t* utf16Text
                                                                                           , unsigned long numUTF16CodeUnits );

typedef WEBKIT_APOLLO_PROTO1 void (WEBKIT_APOLLO_PROTO2* WebViewConfirmCurrentCompositionFunction)( WebView* webView, unsigned char preserveSelection );

typedef WEBKIT_APOLLO_PROTO1 unsigned char (WEBKIT_APOLLO_PROTO2* WebViewGetSelectedRangeFunction)( WebView* webView
                                                                                         , int *startSelection
                                                                                         , int *endSelection
                                                                                         , unsigned char *isEditable );

typedef WEBKIT_APOLLO_PROTO1 void (WEBKIT_APOLLO_PROTO2* WebViewSetSelectedRangeFunction)( WebView* webView
                                                                                         , int startSelection
                                                                                         , int endSelection );

typedef WEBKIT_APOLLO_PROTO1 unsigned char (WEBKIT_APOLLO_PROTO2* WebViewGetCompositionRangeFunction)( WebView* webView
                                                                                            , int *startComposition
                                                                                            , int *endComposition );

typedef WEBKIT_APOLLO_PROTO1 void (WEBKIT_APOLLO_PROTO2* WebViewGetFirstRectForCharacterRangeFunction)( WebView* webView
                                                                                                            , int startRange
                                                                                                            , int endRange
                                                                                                            , WebIntRect *rect );

typedef WEBKIT_APOLLO_PROTO1 unsigned char (WEBKIT_APOLLO_PROTO2* WebViewGetTextForCharacterRangeFunction)( WebView* webView
                                                                                                            , int startRange
                                                                                                            , int endRange
                                                                                                            , uint16_t *text );

typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnDragEnterFunction )( WebView* pWebView
                                                                                      , int const localX
                                                                                      , int const localY
                                                                                      , int const screenX
                                                                                      , int const screenY
                                                                                      , unsigned char const shiftKey
                                                                                      , unsigned char const ctrlKey
                                                                                      , unsigned char const altKey
                                                                                      , unsigned char const metaKey
                                                                                      , WebScriptProxyVariant *dataTransfer );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnDragOverFunction )( WebView* pWebView
                                                                                              , int const localX
                                                                                              , int const localY
                                                                                              , int const screenX
                                                                                              , int const screenY
                                                                                              , unsigned char const shiftKey
                                                                                              , unsigned char const ctrlKey
                                                                                              , unsigned char const altKey
                                                                                              , unsigned char const metaKey
                                                                                              , WebScriptProxyVariant *dataTransfer );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnDragDropFunction )( WebView* pWebView
                                                                                              , int const localX
                                                                                              , int const localY
                                                                                              , int const screenX
                                                                                              , int const screenY
                                                                                              , unsigned char const shiftKey
                                                                                              , unsigned char const ctrlKey
                                                                                              , unsigned char const altKey
                                                                                              , unsigned char const metaKey
                                                                                              , WebScriptProxyVariant *dataTransfer );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewOnDragExitFunction )( WebView* pWebView
                                                                                     , int const localX
                                                                                     , int const localY
                                                                                     , int const screenX
                                                                                     , int const screenY
                                                                                     , unsigned char const shiftKey
                                                                                     , unsigned char const ctrlKey
                                                                                     , unsigned char const altKey
                                                                                     , unsigned char const metaKey
                                                                                     , WebScriptProxyVariant *dataTransfer );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewOnDragStartFunction )( WebView* pWebView
                                                                                               , int const localX
                                                                                               , int const localY
                                                                                               , int const screenX
                                                                                               , int const screenY
                                                                                               , unsigned char const shiftKey
                                                                                               , unsigned char const ctrlKey
                                                                                               , unsigned char const altKey
                                                                                               , unsigned char const metaKey );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewOnDragUpdateFunction )( WebView* pWebView
                                                                                               , int const localX
                                                                                               , int const localY
                                                                                               , int const screenX
                                                                                               , int const screenY
                                                                                               , unsigned char const shiftKey
                                                                                               , unsigned char const ctrlKey
                                                                                               , unsigned char const altKey
                                                                                               , unsigned char const metaKey );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewOnDragCompleteFunction )( WebView* pWebView
                                                                                         , int const localX
                                                                                         , int const localY
                                                                                         , int const screenX
                                                                                         , int const screenY
                                                                                         , unsigned char const shiftKey
                                                                                         , unsigned char const ctrlKey
                                                                                         , unsigned char const altKey
                                                                                         , unsigned char const metaKey
                                                                                         , const uint16_t *dropEffect );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnCutFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnCopyFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnPasteFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewOnSelectAllFunction )( WebView* pWebView );

typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewSendResizeEventFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewSendScrollEventFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewConvertToRootContentFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewSetShouldPaintDefaultBackgroundFunction )(	WebView* pWebView, unsigned char newValue );

typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewGetContextMenuItemsFunction )( WebView* pWebView, WebMenuItem*** items, int *nItems );

typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewGetContextMenuItemInfoFunction )( WebView* pWebView, WebMenuItem* item, short **title, unsigned int *titleCharLen, int *type, unsigned char *checked, unsigned char *enabled, int *action, WebMenuItem ***subMenuItems, int *numSubMenuItems );


typedef WEBKIT_APOLLO_PROTO1 unsigned char ( WEBKIT_APOLLO_PROTO2 *WebViewHasFocusableContentFunction )( WebView* pWebView );
typedef WEBKIT_APOLLO_PROTO1 void ( WEBKIT_APOLLO_PROTO2 *WebViewSetPageGroupName )( struct WebView* pWebFrame, const uint16_t* groupName );
typedef WEBKIT_APOLLO_PROTO1 WebString* ( WEBKIT_APOLLO_PROTO2 *WebViewGetPageGroupName )( struct WebView* pWebFrame );
typedef WEBKIT_APOLLO_PROTO1 void (WEBKIT_APOLLO_PROTO2* WebViewSetTextEncodingOverrideFunction)( WebView* webView
																								, const uint16_t* utf16Text
																								, unsigned long numUTF16CodeUnits);
typedef WEBKIT_APOLLO_PROTO1 void (WEBKIT_APOLLO_PROTO2* WebViewGetTextEncodingOverrideFunction)( WebView* webView
																								, uint16_t** utf16Text);
typedef WEBKIT_APOLLO_PROTO1 void (WEBKIT_APOLLO_PROTO2* WebViewSetTextEncodingFallbackFunction)( WebView* webView
																								, const uint16_t* utf16Text
																								, unsigned long numUTF16CodeUnits);
typedef WEBKIT_APOLLO_PROTO1 void (WEBKIT_APOLLO_PROTO2* WebViewGetTextEncodingFallbackFunction)( WebView* webView
																								, uint16_t** utf16Texts);


struct WebViewVTable {
    unsigned long m_vTableSize;
    WebViewDestroyFunction destroy;
    WebViewMainFrameFunction mainFrame;
    WebViewLayoutFunction layout;
    WebViewPaintFunction paint;
    WebViewOnContextMenuItemSelectFunction onContextMenuItemSelect;
    WebViewOnContextMenuFunction onContextMenu;
    WebViewOnMouseDownFunction onMouseDown;
    WebViewOnMouseUpFunction onMouseUp;
    WebViewOnMouseMoveFunction onMouseMove;
    WebViewOnMouseWheelFunction onMouseWheel;
    WebViewOnFocusInFunction onFocusIn;
    WebViewOnFocusOutFunction onFocusOut;
    WebViewOnWindowActivateFunction onWindowActivate;
    WebViewOnWindowDeactivateFunction onWindowDeactivate;
    WebViewOnKeyDownFunction onKeyDown;
    WebViewOnKeyUpFunction onKeyUp;
    WebViewOnKeyPressFunction onKeyPress;
    WebViewInsertTextFunction insertText;
    WebViewSetCompositionFunction setComposition;
    WebViewConfirmCompositionFunction confirmComposition;
    WebViewConfirmCurrentCompositionFunction confirmCurrentComposition;
    WebViewGetSelectedRangeFunction getSelectedRange;
    WebViewSetSelectedRangeFunction setSelectedRange;
    WebViewGetCompositionRangeFunction getCompositionRange;
    WebViewGetFirstRectForCharacterRangeFunction getFirstRectForCharacterRange;
	WebViewGetTextForCharacterRangeFunction getTextForCharacterRange;
    WebViewOnDragEnterFunction onDragEnter;
    WebViewOnDragOverFunction onDragOver;
    WebViewOnDragDropFunction onDragDrop;
    WebViewOnDragExitFunction onDragExit;
    WebViewOnDragStartFunction onDragStart;
    WebViewOnDragUpdateFunction onDragUpdate;
    WebViewOnDragCompleteFunction onDragComplete;
    WebViewOnCutFunction onCut;
    WebViewOnCopyFunction onCopy;
    WebViewOnPasteFunction onPaste;
    WebViewOnSelectAllFunction onSelectAll;
    WebViewSendResizeEventFunction sendResizeEvent;
    WebViewSendScrollEventFunction sendScrollEvent;
    WebViewConvertToRootContentFunction convertToRootContent;
	WebViewSetShouldPaintDefaultBackgroundFunction setShouldPaintDefaultBackground;
    WebViewGetContextMenuItemsFunction getContextMenuItems;
    WebViewGetContextMenuItemInfoFunction getContextMenuItemInfo;
    WebViewHasFocusableContentFunction hasFocusableContent;
    WebViewSetPageGroupName setPageGroupName;
    WebViewGetPageGroupName getPageGroupName;
	WebViewSetTextEncodingOverrideFunction setTextEncodingOverride;
	WebViewGetTextEncodingOverrideFunction getTextEncodingOverride;
	WebViewSetTextEncodingFallbackFunction setTextEncodingFallback;
	WebViewGetTextEncodingFallbackFunction getTextEncodingFallback;
};

struct WebView {
    const WebViewVTable* m_pVTable;
};

#undef bool

#endif
