#include "config.h"
#include "CookieJar.h"
#include <WebKitApollo/WebKit.h>

#include "DeprecatedString.h"
#include "KURL.h"
#include "PlatformString.h"
#include "StringHash.h"
#include <wtf/HashMap.h>

namespace WebKitApollo { extern WebKitAPIHostFunctions* g_HostFunctions;}

namespace WebCore {

#define SIZE_OF_LATIN1_BUFFERS 4096
#define SIZE_OF_COLONSLASHSLASH 3

void setCookies(const KURL& url, const KURL& policyURL, const String& value)
{
    DeprecatedString str = url.url();
    
    DeprecatedString result("Set-Cookie:");
    //TODO_AIRLinux: SecurityCheck for cookies from correct domain. network/curl/CookieManager.cpp

    DeprecatedString val = value.deprecatedString();

    //add everything in the cookie
    result.append(val);

    //Check if it had appended domain, path
    bool noDomainSet = !val.contains(DeprecatedString("domain="));
    bool noPathSet = !val.contains(DeprecatedString("path="));


    if(noDomainSet || noPathSet)
    {
        char pathBuffer[SIZE_OF_LATIN1_BUFFERS];
        char domainBuffer[SIZE_OF_LATIN1_BUFFERS];

        int tl_domainLocationInUrlBegins = str.find("://") + SIZE_OF_COLONSLASHSLASH;
        int tl_domainLocationInUrlEnds = str.find("/",tl_domainLocationInUrlBegins) - 1;
        result.append(';');
        
        if(noDomainSet)
        {
            str.copyLatin1(domainBuffer, tl_domainLocationInUrlBegins, 
                           tl_domainLocationInUrlEnds - tl_domainLocationInUrlBegins + 1);
            domainBuffer[tl_domainLocationInUrlEnds - tl_domainLocationInUrlBegins + 1] = '\0';
            result.append(DeprecatedString(" domain="));
            result.append(DeprecatedString::fromLatin1(domainBuffer));
            result.append(';');
        }

        if(noPathSet)
        {
            int tl_pathLocationInUrlEnds = str.findRev("/");
            str.copyLatin1(pathBuffer, tl_domainLocationInUrlEnds + 1, // 1 because it'll include '/'
                           tl_pathLocationInUrlEnds - tl_domainLocationInUrlEnds ); 
            pathBuffer[tl_pathLocationInUrlEnds = tl_domainLocationInUrlEnds] = '\0';
            result.append(DeprecatedString(" path="));
            result.append(DeprecatedString::fromLatin1(pathBuffer));
            result.append(';');
        }
    }

    if(val.startsWith(DeprecatedString("https://")))
    {
        result.append(DeprecatedString(" secure"));
    }

    //Connect with Runtime.    
    //
    WebKitApollo::g_HostFunctions->setJavaScriptCookie(result.latin1());
}


String cookies(const KURL& url)
{
    DeprecatedString str = url.url();
    char domainBuffer[SIZE_OF_LATIN1_BUFFERS];
    char pathBuffer[SIZE_OF_LATIN1_BUFFERS];
    int tl_domainLocationInUrlBegins = str.find("://") + SIZE_OF_COLONSLASHSLASH;
    int tl_domainLocationInUrlEnds = str.find("/",tl_domainLocationInUrlBegins) - 1;
    int tl_pathLocationInUrlEnds = str.findRev("/");
    
    strncpy(domainBuffer, str.ascii() + tl_domainLocationInUrlBegins, tl_domainLocationInUrlEnds - tl_domainLocationInUrlBegins + 1);
    domainBuffer[tl_domainLocationInUrlEnds - tl_domainLocationInUrlBegins + 1] = '\0';

    strncpy(pathBuffer, str.ascii() + tl_domainLocationInUrlEnds + 1, tl_pathLocationInUrlEnds - tl_domainLocationInUrlEnds);
    pathBuffer[tl_pathLocationInUrlEnds - tl_domainLocationInUrlEnds] = '\0';

    char* cookStr = WebKitApollo::g_HostFunctions->getJavaScriptCookies(domainBuffer,pathBuffer);
    if(!cookStr)
    {
        return String();
    }

    String cookieString(cookStr);
    ::free(cookStr);
    return cookieString;
}

bool cookiesEnabled()
{
    //TODO_AIRLinux: As of now set to true always (similar implementation on Windows)
    return true;
}

}
