/*
 * Copyright 2007 Adobe Systems Incorporated. All Rights Reserved.
 * Copyright (C) 2006 Apple Computer, Inc.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
#ifndef WidgetApolloDefaultImpl_h
#define WidgetApolloDefaultImpl_h

#include "IWidgetApolloImpl.h"
#include "Font.h"
#include <Cursor.h>

namespace WebCore
{
	class WidgetClient;
	class Font;
	class Cursor;
	class GraphicsContext;
	class PlatformMouseEvent;
	class PlatformKeyboardEvent;

	class WidgetApolloDefaultImpl : public IWidgetApolloImpl
	{
	protected:
		WidgetApolloDefaultImpl();
		virtual ~WidgetApolloDefaultImpl();
	public:
		static WTF::PassRefPtr< WidgetApolloDefaultImpl > construct();


        virtual void setEnabled(bool);
        virtual bool isEnabled() const;
        
		virtual void paint( GraphicsContext* pGraphicsContext, const IntRect& dirtyRect );
		virtual void invalidateRect(const IntRect&);
        
        virtual IntRect frameGeometry() const;
        virtual void setFrameGeometry(const IntRect &rect);
        
		virtual void setFocus();
        
		virtual void setCursor( const Cursor& cursor );
        virtual Cursor cursor();
        
		virtual void show();
		virtual void hide();
        
        virtual void setIsSelected( bool bSelected );

        virtual void setClient(WidgetClient* pClient);
        virtual WidgetClient* client() const;
        
		virtual void removeFromParent();


		virtual bool hasMouseCapture() const;
		virtual void setMouseCapture();
		virtual void releaseMouseCapture();

        virtual PassRefPtr<KJS::Bindings::Instance> getInstance(Frame*);
        virtual void* createPluginScriptableObject();
        virtual void releasePluginScriptableObject(void*);

		//These methods are needed on the APOLLO platform because
		//there is no other way for a "widget" to receive input events.
		//The ApolloWebKit::ApolloWebFrameImpl calls the methods to pass events
		//to its childrent WebCore::Widgets.  These WebCore::Widget could really be
		//frames or iframes.
		virtual bool handleMousePressEvent( const WebCore::PlatformMouseEvent& mouseEvent );
		virtual bool handleMouseMoveEvent( const WebCore::PlatformMouseEvent& mouseEvent );
		virtual bool handleMouseReleaseEvent( const WebCore::PlatformMouseEvent& mouseEvent );
		virtual bool handleWheelEvent( WebCore::PlatformWheelEvent& wheelEvent );
		virtual bool handleKeyboardEvent( const WebCore::PlatformKeyboardEvent& keyEvent );
        virtual bool handleInsertText(const String& text);
        virtual bool handleCut();
        virtual bool handleCopy();
        virtual bool handlePaste();
        virtual bool handleSelectAll();
        
        virtual IScrollViewApolloImpl* getParent();
        virtual WebWindow* getWindow();
        
        virtual void onFocus();
        virtual void onBlur();

        virtual bool widgetNeedsMouseDownFromEventHandler() const;
        
        virtual WTF::PassRefPtr<IPluginWidgetApolloImpl> toPluginWidgetImpl();
        
        virtual bool isInVisibleViewHierarchy() const;
    protected:
        virtual void setParent(IScrollViewApolloImpl*);
	private:
		WidgetClient* m_pClient;
		IntRect m_FrameGeometry;
        Cursor m_cursor;
	};
}


#endif
