/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#include "config.h"
#include "WidgetApolloDefaultImpl.h"
#include "IScrollViewApolloImpl.h"
#include "IPluginWidgetApolloImpl.h"
namespace WebCore
{

	WidgetApolloDefaultImpl::WidgetApolloDefaultImpl()
		:	m_pClient( NULL )
	{
	}

	WidgetApolloDefaultImpl::~WidgetApolloDefaultImpl()
	{
	}

	IntRect WidgetApolloDefaultImpl::frameGeometry() const
	{
		return m_FrameGeometry;
	}

	void WidgetApolloDefaultImpl::paint(GraphicsContext* pGraphicsContext, const IntRect& dirtyRect)
	{
	}

	void WidgetApolloDefaultImpl::invalidateRect(const IntRect& dirtyRect)
	{
	}

	void WidgetApolloDefaultImpl::setCursor(const Cursor& cursor)
	{
        m_cursor = cursor;
	}

    WebCore::Cursor WidgetApolloDefaultImpl::cursor()
    {
        return m_cursor;
	}

	void WidgetApolloDefaultImpl::show()
	{
	}
	
	void WidgetApolloDefaultImpl::hide()
	{
	}
	
	void WidgetApolloDefaultImpl::removeFromParent()
	{
	}

	void WidgetApolloDefaultImpl::setFrameGeometry(const IntRect &rect)
	{
		m_FrameGeometry = rect;
	}

	WTF::PassRefPtr< WidgetApolloDefaultImpl > WidgetApolloDefaultImpl::construct()
	{
		return adoptRef(new WidgetApolloDefaultImpl());
	}

	void WidgetApolloDefaultImpl::setClient( WidgetClient* pClient)
	{
		m_pClient = pClient;
	}

	WidgetClient* WidgetApolloDefaultImpl::client() const
	{
		return m_pClient;
	}

	void WidgetApolloDefaultImpl::setFocus()
	{
	}

	bool WidgetApolloDefaultImpl::hasMouseCapture() const
	{
		return false;
	}

	void WidgetApolloDefaultImpl::setMouseCapture()
	{
	}

	void WidgetApolloDefaultImpl::releaseMouseCapture()
	{
	}
    
    PassRefPtr<KJS::Bindings::Instance> WidgetApolloDefaultImpl::getInstance(Frame*)
	{
        //Should only be called on plugin widget impls...
        ASSERT(false);
        return 0;
	}
    
    void* WidgetApolloDefaultImpl::createPluginScriptableObject()
    {
        //Should only be called on plugin widget impls...
        ASSERT(false);
        return 0;
    }
    
    void WidgetApolloDefaultImpl::releasePluginScriptableObject(void *)
    {
        //Should only be called on plugin widget impls...
        ASSERT(false);
    }

	bool WidgetApolloDefaultImpl::isEnabled() const
	{
		return false;
	}

	void WidgetApolloDefaultImpl::setEnabled(bool bEnabled)
	{
	}
	
	void WidgetApolloDefaultImpl::setIsSelected(bool bSelected)
	{
	}

	bool WidgetApolloDefaultImpl::handleMousePressEvent(const WebCore::PlatformMouseEvent& mouseEvent)
	{
        return false;
	}
	
    bool WidgetApolloDefaultImpl::handleMouseMoveEvent(const WebCore::PlatformMouseEvent& mouseEvent)
	{
        return false;
	}
	
    bool WidgetApolloDefaultImpl::handleMouseReleaseEvent(const WebCore::PlatformMouseEvent& mouseEvent)
	{
        return false;
	}
    
    bool WidgetApolloDefaultImpl::handleWheelEvent(WebCore::PlatformWheelEvent& wheelEvent)
	{
        return false;
	}
    
	bool WidgetApolloDefaultImpl::handleKeyboardEvent(const WebCore::PlatformKeyboardEvent& keyEvent)
	{
        return false;
	}

    bool WidgetApolloDefaultImpl::handleInsertText(const String&)
    {
        return false;
    }

    bool WidgetApolloDefaultImpl::handleCut()
    {
        return false;
    }
    
    bool WidgetApolloDefaultImpl::handleCopy()
    {
        return false;
    }
    
    bool WidgetApolloDefaultImpl::handlePaste()
    {
        return false;
    }
    
    bool WidgetApolloDefaultImpl::handleSelectAll()
    {
        return false;
    }
    
    IScrollViewApolloImpl* WidgetApolloDefaultImpl::getParent()
    {
        ASSERT(false);
        return NULL;
    }
    
    ::WebWindow *WidgetApolloDefaultImpl::getWindow()
    {
        WebCore::IScrollViewApolloImpl* parent = getParent();
        if(parent != NULL)
            return parent->getWindow();
        else return NULL;
    }
    
    void WidgetApolloDefaultImpl::setParent(IScrollViewApolloImpl*)
    {
        ASSERT(false);
    }
    
    void WidgetApolloDefaultImpl::onFocus()
    {
        ASSERT(false);
    }
    
    void WidgetApolloDefaultImpl::onBlur()
    {
        ASSERT(false);
    }

    bool WidgetApolloDefaultImpl::widgetNeedsMouseDownFromEventHandler() const
    {
        return false;
    }
    
    WTF::PassRefPtr<IPluginWidgetApolloImpl> WidgetApolloDefaultImpl::toPluginWidgetImpl()
    {
        return WTF::PassRefPtr<IPluginWidgetApolloImpl>();
    }
    
    bool WidgetApolloDefaultImpl::isInVisibleViewHierarchy() const
    {
        return false;
    }
}
