/*
 * Copyright (C) 2004, 2006 Apple Computer, Inc.  All rights reserved.
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 * 
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE COMPUTER, INC. ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL APPLE COMPUTER, INC. OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY
 * OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 */
#ifndef PlatformScrollbar_h
#define PlatformScrollbar_h

#include <Widget.h>
#include <ScrollBar.h>
#include <Timer.h>
#include <IntRect.h>
#include <FloatPoint.h>
#include <PlatformMouseEvent.h>

namespace WebCore {

class Frame;
class FrameView;
class EventTargetNode;
class MouseEvent;
class PlatformKeyboardEvent;
class PlatformScrollbarEventHandler;
class String;

class PlatformScrollbar : public Widget, public Scrollbar {
    friend class PlatformScrollbarEventHandler;
public:
    PlatformScrollbar(ScrollbarClient*, ScrollbarOrientation, ScrollbarControlSize, Frame* const frame);
    virtual ~PlatformScrollbar();

    virtual bool isWidget() const { return true; }

    virtual int width() const;
    virtual int height() const;
    virtual void setRect(const IntRect&);
    virtual void setEnabled(bool);
    virtual void paint(GraphicsContext*, const IntRect& damageRect);

    static int horizontalScrollbarHeight() { return 15; }
    static int verticalScrollbarWidth() { return 15; }
public:
    
    bool handleMousePressEventNormalized(const PlatformMouseEvent& mouseEvent );
    virtual bool handleMouseMoveEvent(const PlatformMouseEvent& mouseEvent );
    bool handleMouseMoveEventNormalized(const PlatformMouseEvent& mouseEvent );
    bool handleMouseReleaseEventNormalized(const PlatformMouseEvent& mouseEvent );
    virtual bool handleKeyboardEvent( const PlatformKeyboardEvent& keyEvent );
    virtual bool handleInsertText(const String& text);
                                    
    PlatformMouseEvent normalizeMouseEvent(const PlatformMouseEvent& mouseEvent);

protected:
    virtual void updateThumbPosition();
    virtual void updateThumbProportion();

    void logMouseEvent( const char * text
                      , const PlatformMouseEvent* origEvent
                      , const PlatformMouseEvent* transEvent = 0);

private:
    void hitTest(MouseEvent* evnt);
    void scrollIfNeeded();

private:

    void hitTestImplHelper( const IntRect& rectToTest
                          , const IntPoint& position
                          , bool const isMouseDownEvent
                          , bool* isOver
                          , bool* isDown
                          , bool* preventDefault);
    enum MouseEventType {
        MouseEventType_Down,
        MouseEventType_Up,
        MouseEventType_Move
    };
    void hitTestImpl(   MouseEventType type,
                        const IntPoint& pos,
                        bool* preventDefault );
	bool isDisconnected();

    void scrollTimerFired(Timer<PlatformScrollbar>*);
    Timer<PlatformScrollbar> m_scrollTimer;

    FrameView* m_frameView;
    
    IntRect m_scrollbarRect;
    IntRect m_firstButtonRect;
    IntRect m_secondButtonRect;
    IntRect m_thumbRect;
    IntRect m_firstSlackSpaceRect;
    IntRect m_secondSlackSpaceRect;
#if 0 // may need this for styled scrollbars one day
    FloatPoint m_firstArrow[3];
    FloatPoint m_secondArrow[3];
#endif

    bool m_mousedownFirstButton;
    bool m_mouseoverFirstButton;
    bool m_mousedownSecondButton;
    bool m_mouseoverSecondButton;
    bool m_mousedownFirstSlackSpace;
    bool m_mouseoverFirstSlackSpace;
    bool m_mousedownSecondSlackSpace;
    bool m_mouseoverSecondSlackSpace;
    bool m_mousedownThumb;
    bool m_mouseoverThumb;

    float m_sizeOfThumbAreaInPixels;
    float m_thumbClickOffset;
    float m_thumbValueInPixels;
    float m_thumbMinValueinPixles;
    float m_visibleToTotalRatio;

	bool m_isEnabled;

};

}

#endif // PlatformScrollbar_h

