#include <config.h>

#include <WebKitApollo/WebHost.h>
#include <FrameLoaderClientApollo.h>

namespace WebCore {

String defaultLanguage(Frame * const frame)
{
    WebCore::FrameLoaderClientApollo* clientApollo = WebCore::FrameLoaderClientApollo::clientApollo(frame);
    WebHost* webHost = clientApollo->webHost();

    int numChars = 0;
    const uint16_t* lang =  webHost->m_pVTable->getLanguage(webHost, &numChars);

    return WebCore::String((const UChar*)lang, numChars);
}


} // namespace WebCore
