/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef IWidgetApolloImpl_h
#define IWidgetApolloImpl_h
#include <wtf/Platform.h>

#include "Widget.h"
#include "IntSize.h"
#include "IntRect.h"
#include "FloatRect.h"
#include "Frame.h"

#include "wtf/RefCounted.h"

#include <runtime.h>
#include <WebKitApollo/WebWindow.h>

#if PLATFORM(APOLLO)
struct WebWindow;

namespace WebCore
{
    class WidgetClient;
    class Cursor;
    class GraphicsContext;
    class PlatformMouseEvent;
    class PlatformKeyboardEvent;
    class IScrollViewApolloImpl;
    class IPluginWidgetApolloImpl;

    class IWidgetApolloImpl : public WTF::RefCounted<IWidgetApolloImpl>
    {
        friend class WTF::RefCounted<IWidgetApolloImpl>;
    protected:
        inline IWidgetApolloImpl() {}
        virtual ~IWidgetApolloImpl() {}
    public:
        virtual void setEnabled(bool) = 0;
        virtual bool isEnabled() const = 0;
        
        virtual void paint(GraphicsContext* pGraphicsContext, const IntRect& dirtyRect) = 0;
        virtual void invalidateRect(const IntRect&) = 0;
        
        virtual IntRect frameGeometry() const = 0;
        virtual void setFrameGeometry(const IntRect &rect) = 0;
        
        virtual void setFocus() = 0;
        
        virtual void setCursor(const Cursor& cursor) = 0;
        virtual Cursor cursor() = 0;
        
        virtual void show() = 0;
        virtual void hide() = 0;
        
        virtual void setIsSelected( bool bSelected ) = 0;

        virtual void setClient(WidgetClient* pClient) = 0;
        virtual WidgetClient* client() const = 0;


        //------------- Apollo specific stuff starts here ------------
        virtual bool hasMouseCapture() const = 0;
        virtual void setMouseCapture() = 0;
        virtual void releaseMouseCapture() = 0;

        // this should only be called against PlugIn Widgets
        virtual PassRefPtr<KJS::Bindings::Instance> getInstance(WebCore::Frame *frame) = 0;
        virtual void* createPluginScriptableObject() = 0;
        virtual void releasePluginScriptableObject(void *object) = 0;

        //These methods are needed on the APOLLO platform because
        //there is no other way for a "widget" to receive input events.
        //The ApolloWebKit::ApolloWebFrameImpl calls the methods to pass events
        //to its childrent WebCore::Widgets.  These WebCore::Widget could really be
        //frames or iframes.
        virtual bool handleMousePressEvent(const WebCore::PlatformMouseEvent& mouseEvent) = 0;
        virtual bool handleMouseMoveEvent(const WebCore::PlatformMouseEvent& mouseEvent) = 0;
        virtual bool handleMouseReleaseEvent(const WebCore::PlatformMouseEvent& mouseEvent) = 0;
        virtual bool handleWheelEvent(WebCore::PlatformWheelEvent& wheelEvent) = 0;
        virtual bool handleKeyboardEvent( const WebCore::PlatformKeyboardEvent& keyEvent ) = 0;
        virtual bool handleInsertText(const String& text) = 0;
        virtual bool handleCut() = 0;
        virtual bool handleCopy() = 0;
        virtual bool handlePaste() = 0;
        virtual bool handleSelectAll() = 0;
        
        virtual IScrollViewApolloImpl* getParent() = 0; 
        virtual WebWindow *getWindow() = 0;
        
        virtual void setParent(IScrollViewApolloImpl*) = 0;
        
        // called by webkit apollo's focus manager when
        // a widget is either losing or gaining keyboard
        // focus.
        virtual void onFocus() = 0;
        virtual void onBlur() = 0;

        virtual bool widgetNeedsMouseDownFromEventHandler() const = 0;
        
        virtual WTF::PassRefPtr<IPluginWidgetApolloImpl> toPluginWidgetImpl() = 0;
        
        virtual bool isInVisibleViewHierarchy() const = 0;
    private:
        IWidgetApolloImpl(const IWidgetApolloImpl&);
        IWidgetApolloImpl& operator=(const IWidgetApolloImpl&);
    };
}
#endif

#endif
