#include "config.h"
#include "DragData.h"

#include "ClipboardApollo.h"
#include "ClipboardApolloHelper.h"
#include "ClipboardAccessPolicy.h"
#include "Document.h"
#include "DocumentFragment.h"
#include "MIMETypeRegistry.h"
#include "kjs/object.h"
#include "kjs_binding.h"
#include "FrameLoaderClientApollo.h"

namespace WebCore {

bool DragData::canSmartReplace() const
{
    return false;
}

bool DragData::containsColor() const
{
    return false;
}

bool DragData::containsPlainText() const
{
    HashSet<String> availableTypes(m_platformDragData->types());
    return availableTypes.contains(ClipboardApolloHelper::TEXT_TYPE);
}

String DragData::asPlainText() const
{
    KJS::JSLock lock;
    bool success;
    KJS::JSValue* data = m_platformDragData->getData(ClipboardApolloHelper::TEXT_TYPE, success);
    if (success && data->isString())
        return String(data->toString(m_platformDragData->execState()));

    Vector<String> filenames;
    asFilenames(filenames);
    if (!filenames.isEmpty()) {
        String result;
        for (unsigned int i=0; i<filenames.size(); i++)
            result.append(filenames[i] + "\n");
        return result;
    }

    String url(asURL(NULL));
    if (!url.isEmpty())
        return url;

    return String();
}

Color DragData::asColor() const
{
    return makeRGBA(0, 0, 0, 0);
}

Clipboard* DragData::createClipboard(ClipboardAccessPolicy policy, Frame* frame) const
{
    ASSERT(frame);
    return new ClipboardApollo(true, new ClipboardApolloHelper(*m_platformDragData), policy, frame);
}

bool DragData::containsCompatibleContent() const
{
    HashSet<String> availableTypes(m_platformDragData->types());
    return availableTypes.contains(ClipboardApolloHelper::TEXT_TYPE)
        || availableTypes.contains(ClipboardApolloHelper::HTML_TYPE)
        || availableTypes.contains(ClipboardApolloHelper::URI_LIST_TYPE)
        || availableTypes.contains(ClipboardApolloHelper::BITMAP_TYPE)
        || availableTypes.contains(ClipboardApolloHelper::FILE_LIST_TYPE);
}

bool DragData::containsURL() const
{
    HashSet<String> availableTypes(m_platformDragData->types());
    return availableTypes.contains(ClipboardApolloHelper::URI_LIST_TYPE);
}

String DragData::asURL(String* title) const
{
    KJS::JSLock lock;
    bool success;
    KJS::JSValue* data = m_platformDragData->getData(ClipboardApolloHelper::URI_LIST_TYPE, success);
    if (success && data->isString())
        return String(data->toString(m_platformDragData->execState()));
    return String();
}

PassRefPtr<DocumentFragment> DragData::asFragment(Document* doc) const
{
    return NULL;
}

void DragData::asFilenames(Vector<String>& result) const
{
    bool success;
    KJS::JSValue* data = m_platformDragData->getData(ClipboardApolloHelper::FILE_LIST_TYPE, success);
    KJS::ExecState *exec = m_platformDragData->execState();
    if (success && data->isObject()) {
        KJS::JSObject* filenameArray = data->toObject(exec);
        uint32_t length = filenameArray->get(exec, KJS::Identifier("length"))->toUInt32(exec);
        for (uint32_t i=0; i<length; i++) {
            KJS::JSValue* fileValue = filenameArray->get(exec, i);
            if (fileValue->isObject()) {
                KJS::JSObject* file = fileValue->toObject(exec);
                KJS::JSValue* pathValue = file->get(exec, KJS::Identifier("nativePath"));
                if (pathValue->isString()) {
                    String path = pathValue->toString(exec);
                    result.append(path);
                }
            }
        }
    }
    if (exec->hadException())
        exec->clearException();
}

bool DragData::containsFiles() const
{
    HashSet<String> availableTypes(m_platformDragData->types());
    return availableTypes.contains(ClipboardApolloHelper::FILE_LIST_TYPE);
}

}
