#ifndef ClipboardApolloHelper_h
#define ClipboardApolloHelper_h

#include <AtomicString.h>
#include <DragActions.h>
#include <StringHash.h>
#include <kjs/object.h>
#include <kjs/protect.h>
#include <wtf/HashSet.h>

namespace WebCore {

class ClipboardApolloHelper
{
public:
    static const String TEXT_TYPE, HTML_TYPE, URI_LIST_TYPE, BITMAP_TYPE, FILE_LIST_TYPE;

    ClipboardApolloHelper(KJS::JSObject* clipboard, KJS::ExecState* exec);
    virtual ~ClipboardApolloHelper();

    WTF::HashSet<String> types();
    KJS::JSValue* getData(const String& type, bool& success);
    bool setData(const String& type, KJS::JSValue* data);
    void clearData(const String& type);
    void clearAllData();

    DragOperation dragOperationAllowed();
    void setDragOperation(DragOperation operation);
    void setPropagationStopped(bool stopped);

    String getDataString(const String& type, bool& success);
    bool setData(const String& type, const String& data);

    KJS::JSObject* dataTransfer() const;
    KJS::ExecState* execState() const;

private:
    KJS::ProtectedPtr<KJS::JSObject> m_dataTransfer;
    KJS::ExecState* m_exec;

    void setDropEffect(const String& dropEffect);
};

}

#endif // ClipboardApolloHelper_h
