/*
 * Copyright (C) 2007 Adobe Systems Incorporated.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the Adobe Systems Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY ADOBE SYSTEMS INCORPORATED "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL ADOBE SYSTEMS INCORPORATED
 * OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <config.h>
#include <Frame.h>
#include <FrameView.h>
#include <FrameLoader.h>
#include <FramePrivate.h>
#include <FrameLoaderClientApollo.h>
#include <IScrollViewApolloImpl.h>
#include <Document.h>
#include <WebKitApollo/WebPoint.h>
#include <WebKitApollo/WebRect.h>
#include <WebKitApollo/WebBitmap.h>
#include <WebKitApollo/WebHost.h>
#include <WebKitApollo/WebWindow.h>
#include <FrameView.h>

namespace WebCore {

void Frame::disconnectPlatformScriptObjects()
{
}

void Frame::clearPlatformScriptObjects()
{
}

void Frame::keepAlive()
{
    ASSERT(loader());
    FrameLoaderClientApollo* const client = FrameLoaderClientApollo::clientApollo(this);
    ASSERT(client);
    client->putFrameOnLifeSupport(this);
}

WebBitmap* Frame::imageFromRect(const FloatRect& rect) const
{
    FrameLoaderClientApollo* const clientApollo = FrameLoaderClientApollo::clientApollo(this);
    WebHost* webHost = clientApollo->webHost();
    ASSERT(webHost);

    WebBitmap* resultBitmap = webHost->m_pVTable->createBitmap(webHost, rect.size().width(), rect.size().height());
    WTF::PassRefPtr<IScrollViewApolloImpl> const viewImpl(view()->getApolloImpl());
    WebWindow* window = viewImpl->getWindow();
    WebBitmap* windowBitmap = window->m_pVTable->getBitmapSurface(window);

    WebIntRect sourceRect;
    WebIntPoint destPoint;
	sourceRect.m_left = rect.x();
	sourceRect.m_top = rect.y();
	sourceRect.m_right = rect.right();
	sourceRect.m_bottom = rect.bottom();
	destPoint.m_x = 0;
	destPoint.m_y = 0;
    resultBitmap->m_pVTable->copyPixels(resultBitmap, windowBitmap, &sourceRect, &destPoint);

    return resultBitmap;
}

WebBitmap* Frame::selectionImage(bool forceWhiteText) const
{
    d->m_paintRestriction = forceWhiteText ? PaintRestrictionSelectionOnlyBlackText : PaintRestrictionSelectionOnly;
    WebBitmap* result = imageFromRect(selectionRect(true));
    d->m_paintRestriction = PaintRestrictionNone;
    return result;
}

WebBitmap* Frame::snapshotDragImage(Node* node, IntRect& imageRect, IntRect& elementRect) const
{
    RenderObject* renderer = node->renderer();
    if (!renderer)
        return NULL;

    renderer->updateDragState(true);    // mark dragged nodes (so they pick up the right CSS)
    d->m_doc->updateLayout();        // forces style recalc - needed since changing the drag state might
                                        // imply new styles, plus JS could have changed other things
    IntRect topLevelRect;
    IntRect paintingRect = renderer->paintingRootRect(topLevelRect);

    d->m_elementToDraw = node;              // invoke special sub-tree drawing mode
    WebBitmap* result = imageFromRect(paintingRect);
    renderer->updateDragState(false);
    d->m_doc->updateLayout();
    d->m_elementToDraw = 0;

    elementRect = topLevelRect;
	imageRect = paintingRect;
    return result;
}

DragImageRef Frame::dragImageForSelection() 
{
    if (!selectionController()->isRange())
        return NULL;
    return selectionImage();
}

WTF::PassRefPtr<KJS::Bindings::Instance> Frame::createScriptInstanceForWidget(WebCore::Widget* widget)
{
	const WTF::RefPtr< IWidgetApolloImpl >&impl =  widget->getApolloImpl();

	return impl->getInstance(this);
}

}
