LIB_NAME = WebCore
PRODUCT = WebCore
PRODUCT_LINK = static
VCPROJ_FILE += $(CLIENT_ROOT_DIR)/Content/html/WebCore/WebCore.apolloproj/win/WebCore.vc2005.vcproj

product_default: lib$(LIB_NAME)$(LIB_STATIC_EXT)

webcore_prebuild:
	@BUILD_SHARE_DIR=$(BUILD_SHARE_DIR) \
	CLIENT_ROOT_DIR=$(CLIENT_ROOT_DIR) \
	$(SHELL) $(CLIENT_ROOT_DIR)/Content/html/WebCore/WebCore.apolloproj/unix/WebCore_prebuild.sh

PRE_BUILD_TASKS += webcore_prebuild

CC_FLAGS = $(CC_LIB_FLAGS) $(WARNING_IS_ERROR)
CCPP_FLAGS = $(CCPP_LIB_FLAGS) $(WARNING_IS_ERROR) $(CCPP_NO_RTTI_FLAG) $(CCPP_NO_EXCEPTIONS_FLAG)

# PRODUCT_DEFINES +=
PRODUCT_INCLUDES += $(X_INCLUDES) $(FREETYPE_INCLUDES) $(GTK_INCLUDES) $(PANGOCAIRO_INCLUDES)
# PRODUCT_LIBS +=

include $(BUILD_SHARE_DIR)/Common.mak

WebCore_CPP_SOURCES_extra += \
	"$(CLIENT_ROOT_DIR)/Content/html/WebCore/platform/apollo/ImageApollo.cpp" \
	"$(CLIENT_ROOT_DIR)/Content/html/WebCore/platform/graphics/apollo/ImageApollo.cpp" \


WebCore_CPP_OBJS_extra += \
	ImageApollo_apollo.o \
	ImageApollo_graphics.o \


ImageApollo_apollo.o:
	$(CCPP_FORCE) $(CCPP_FLAGS) $(DEFINES) $(WebCore_PRODUCT_DEFINES) $(INCLUDES) $(WebCore_PRODUCT_INCLUDES) -o $@ -c "$(CLIENT_ROOT_DIR)/Content/html/WebCore/platform/apollo/ImageApollo.cpp"

ImageApollo_graphics.o:
	$(CCPP_FORCE) $(CCPP_FLAGS) $(DEFINES) $(WebCore_PRODUCT_DEFINES) $(INCLUDES) $(WebCore_PRODUCT_INCLUDES) -o $@ -c "$(CLIENT_ROOT_DIR)/Content/html/WebCore/platform/graphics/apollo/ImageApollo.cpp"


CCPP_SOURCES += $(WebCore_CPP_SOURCES_extra)
OBJS += $(WebCore_CPP_OBJS_extra)

WebCore_depends_extra:
	$(CCPP_DEPEND) $(DEFINES) $(WebCore_PRODUCT_DEFINES) $(INCLUDES) $(WebCore_PRODUCT_INCLUDES) \
	$(WebCore_CPP_SOURCES_extra) \
	$(CCPP_DEPEND_POST)

DEPEND_TARGETS += WebCore_depends_extra
