#include "config.h"
#if PLATFORM(APOLLO)
#include "MathExtras.h"
#include <WebKitApollo/WebKit.h>

namespace WebKitApollo {
extern WebKitAPIHostFunctions* g_HostFunctions;
}

namespace {

static char randomNumberGeneratorStateBytes[WebRandomNumberGeneratorStateSize];
static WebRandomNumberGeneratorState* const randomNumberGeneratorState = reinterpret_cast<WebRandomNumberGeneratorState*>(randomNumberGeneratorStateBytes);

}

void wtf_random_init()
{
    WebKitApollo::g_HostFunctions->initRandomNumberGenerator(randomNumberGeneratorState);
}

double wtf_random()
{
    return WebKitApollo::g_HostFunctions->getRandomNumber(randomNumberGeneratorState);
}

#endif



