#This script file assumes the current folder as the component's build folder

if [ -z "${BUILD_SHARE_DIR}" ]
    then
    echo "BUILD_SHARE_DIR not provided"
    exit 1
fi

if [ -z "${CLIENT_ROOT_DIR}" ]
    then
    echo "CLIENT_ROOT_DIR not provided"
    exit 1
fi

#Included to make use of the GenerateRelativePath function
source "${BUILD_SHARE_DIR}/Common.sh"

PERL_CMD="/usr/bin/perl" 
PERL_INC="-I${CLIENT_ROOT_DIR}/SDK/unix/i80386linux/modules/perl"
CREATE_HASH_TABLE="${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/create_hash_table"
DFTABLES_CMD="${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/pcre/dftables"

if [ ! -f "${PERL_CMD}" ]
    then
    echo "Missing perl - ${PERL_CMD}"
    exit 1
fi

if [ ! -f "${DFTABLES_CMD}" ]
    then
    echo "Missing dftables - ${DFTABLES_CMD}"
    exit 1
fi

if [ ! -f "${CREATE_HASH_TABLE}" ]
    then
    echo "Missing create_hash_table - ${CREATE_HASH_TABLE}"
    exit 1
fi

do_create_hash_table()
{
    if [ ! -f "$2" ]
	then
	${PERL_CMD} ${PERL_INC} ${CREATE_HASH_TABLE} $1 -i > $2.tmp
	if [ $? -ne 0 ]
	    then
	    echo "Failure in command :----"
	    echo "${PERL_CMD} ${PERL_INC} ${CREATE_HASH_TABLE} $1 -i > $2.tmp"
	    exit 1
	fi
	
	cp $2.tmp $2
	if [ $? -ne 0 ]
	    then
	    echo "Error copying $2.tmp onto $2"
	fi
    fi
}

do_grammar_create()
{
    if [ ! -f "grammar.cpp" ] || [ ! -f "grammar.h" ]
	then
	if [ -f grammar.tmp.cpp ]
	    then
	    rm -f grammar.tmp.cpp
	fi
	
	if [ -f grammar.tmp.hpp ]
	    then
	    rm -f grammar.tmp.hpp
	fi
	
	bison -d -p kjsyy ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/grammar.y -o grammar.tmp.cpp
	if [ $? -ne 0 ]
	    then
	    echo "Failure in command :----"
	    echo "bison -d -p kjsyy ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/grammar.y -o grammar.tmp.cpp"
	    exit 1
	fi
	
	cp grammar.tmp.cpp grammar.cpp
	if [ $? -ne 0 ]
	    then
	    echo "Error copying grammar.tmp.cpp onto grammar.cpp"
	fi
	
	cp grammar.tmp.hpp grammar.h
	if [ $? -ne 0 ]
	    then
	    echo "Error copying grammar.tmp.hpp onto grammar.h"
	fi
    fi
}

do_dftable()
{
    if [ ! -f "chartables.c" ]
	then
	${DFTABLES_CMD} chartables.c
    fi
}

do_create_link()
{
    if [ ! -L "$2" ]
	then
	
	if [ ! -e "$1" ]
	    then
	    echo "Could not create link $2 on $1. Source does not exist."
	    return 1
	fi

	OLD_DIR="`pwd`"

	cd "`dirname $1`"
	ABSOLUTE_SRC="`pwd`"
	cd "$OLD_DIR"

	cd "`dirname $2`"
	ABSOLUTE_DST="`pwd`"
	cd "$OLD_DIR"

	RELATIVE_SRC="`GetRelativePath ${ABSOLUTE_DST} ${ABSOLUTE_SRC}`"
	ln -s "${RELATIVE_SRC}/`basename $1`" "${ABSOLUTE_DST}/`basename $2`"
	if [ $? -ne 0 ]
	    then
	    echo "Could not create link $2 to $1"
	fi
    fi
}

do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/array_object.cpp array_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/bool_object.cpp bool_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/date_object.cpp date_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/error_object.cpp error_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/function_object.cpp function_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/math_object.cpp math_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/number_object.cpp number_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/object_object.cpp object_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/regexp_object.cpp regexp_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/string_object.cpp string_object.lut.h
do_create_hash_table ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/keywords.table lexer.lut.h

do_grammar_create
do_dftable

if [ ! -d "./JavaScriptCore" ]
    then
    mkdir JavaScriptCore
    if [ $? -ne 0 ]
	then
	echo "Could not create the JavaScriptCore folder for copying common include files."
	exit 1
    fi
fi

do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/API/APICast.h JavaScriptCore/APICast.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/API/JSBase.h JavaScriptCore/JSBase.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/API/JSContextRef.h JavaScriptCore/JSContextRef.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/API/JSObjectRef.h JavaScriptCore/JSObjectRef.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/API/JSStringRef.h JavaScriptCore/JSStringRef.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/API/JSValueRef.h JavaScriptCore/JSValueRef.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/API/JavaScriptCore.h JavaScriptCore/JavaScriptCore.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/bindings/runtime.h JavaScriptCore/runtime.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/bindings/NP_jsobject.h JavaScriptCore/NP_jsobject.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/bindings/npruntime_impl.h JavaScriptCore/npruntime_impl.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/bindings/runtime_root.h JavaScriptCore/runtime_root.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/bindings/npruntime.h JavaScriptCore/npruntime.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/bindings/runtime_object.h JavaScriptCore/runtime_object.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/bindings/npapi.h JavaScriptCore/npapi.h
do_create_link ${CLIENT_ROOT_DIR}/Content/html/JavaScriptCore/kjs/JSLock.h JavaScriptCore/JSLock.h

exit 0
