/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitAnimationList.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSWebKitAnimation.h"
#include "WebKitAnimation.h"
#include "WebKitAnimationList.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitAnimationList);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitAnimationListTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationListLength), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationListConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationListTable = { 5, 3, JSWebKitAnimationListTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitAnimationListConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationListConstructorTable = { 1, 0, JSWebKitAnimationListConstructorTableValues, 0 };
class JSWebKitAnimationListConstructor : public DOMConstructorObject {
private:
    JSWebKitAnimationListConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSWebKitAnimationListConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSWebKitAnimationListConstructor* ptr = new (JSC::allocateCell<JSWebKitAnimationListConstructor>(*exec->heap())) JSWebKitAnimationListConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSWebKitAnimationListConstructor::s_info = { "WebKitAnimationListConstructor", &DOMConstructorObject::s_info, &JSWebKitAnimationListConstructorTable, 0 };

JSWebKitAnimationListConstructor::JSWebKitAnimationListConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitAnimationListConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitAnimationListPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitAnimationListConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationListConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationListConstructorTable, this, propertyName, slot);
}

bool JSWebKitAnimationListConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitAnimationListConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationListConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitAnimationListPrototypeTableValues[] =
{
    { "item", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitAnimationListPrototypeFunctionItem), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationListPrototypeTable = { 2, 1, JSWebKitAnimationListPrototypeTableValues, 0 };
const ClassInfo JSWebKitAnimationListPrototype::s_info = { "WebKitAnimationListPrototype", &JSC::JSNonFinalObject::s_info, &JSWebKitAnimationListPrototypeTable, 0 };

JSObject* JSWebKitAnimationListPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitAnimationList>(exec, globalObject);
}

bool JSWebKitAnimationListPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSWebKitAnimationListPrototypeTable, this, propertyName, slot);
}

bool JSWebKitAnimationListPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSWebKitAnimationListPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSWebKitAnimationList::s_info = { "WebKitAnimationList", &JSDOMWrapper::s_info, &JSWebKitAnimationListTable, 0 };

JSWebKitAnimationList::JSWebKitAnimationList(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitAnimationList> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSWebKitAnimationList::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitAnimationList::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitAnimationListPrototype::create(exec->globalData(), globalObject, JSWebKitAnimationListPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSWebKitAnimationList::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    const HashEntry* entry = JSWebKitAnimationListTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<WebKitAnimationList*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSWebKitAnimationList, Base>(exec, &JSWebKitAnimationListTable, this, propertyName, slot);
}

bool JSWebKitAnimationList::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    const HashEntry* entry = JSWebKitAnimationListTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(this, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(ok);
    if (ok && index < static_cast<WebKitAnimationList*>(impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(this, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete | ReadOnly);
        return true;
    }
    return getStaticValueDescriptor<JSWebKitAnimationList, Base>(exec, &JSWebKitAnimationListTable, this, propertyName, descriptor);
}

bool JSWebKitAnimationList::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    if (propertyName < static_cast<WebKitAnimationList*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValue jsWebKitAnimationListLength(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimationList* castedThis = static_cast<JSWebKitAnimationList*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimationList* imp = static_cast<WebKitAnimationList*>(castedThis->impl());
    JSValue result = jsNumber(imp->length());
    return result;
}


JSValue jsWebKitAnimationListConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimationList* domObject = static_cast<JSWebKitAnimationList*>(asObject(slotBase));
    return JSWebKitAnimationList::getConstructor(exec, domObject->globalObject());
}

void JSWebKitAnimationList::getOwnPropertyNames(ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    for (unsigned i = 0; i < static_cast<WebKitAnimationList*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(exec, propertyNames, mode);
}

JSValue JSWebKitAnimationList::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitAnimationListConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitAnimationListPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitAnimationList::s_info))
        return throwVMTypeError(exec);
    JSWebKitAnimationList* castedThis = static_cast<JSWebKitAnimationList*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitAnimationList::s_info);
    WebKitAnimationList* imp = static_cast<WebKitAnimationList*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    unsigned index(exec->argument(0).toUInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->item(index)));
    return JSValue::encode(result);
}


JSValue JSWebKitAnimationList::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSWebKitAnimationList* thisObj = static_cast<JSWebKitAnimationList*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<WebKitAnimationList*>(thisObj->impl())->item(index));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebKitAnimationList* impl)
{
    return wrap<JSWebKitAnimationList>(exec, globalObject, impl);
}

WebKitAnimationList* toWebKitAnimationList(JSC::JSValue value)
{
    return value.inherits(&JSWebKitAnimationList::s_info) ? static_cast<JSWebKitAnimationList*>(asObject(value))->impl() : 0;
}

}
