/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSWebKitAnimation.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "WebKitAnimation.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebKitAnimation);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitAnimationTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "duration", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDuration), (intptr_t)0 THUNK_GENERATOR(0) },
    { "elapsedTime", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationElapsedTime), (intptr_t)setJSWebKitAnimationElapsedTime THUNK_GENERATOR(0) },
    { "delay", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDelay), (intptr_t)0 THUNK_GENERATOR(0) },
    { "iterationCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationIterationCount), (intptr_t)0 THUNK_GENERATOR(0) },
    { "paused", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationPaused), (intptr_t)0 THUNK_GENERATOR(0) },
    { "ended", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationEnded), (intptr_t)0 THUNK_GENERATOR(0) },
    { "direction", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDirection), (intptr_t)0 THUNK_GENERATOR(0) },
    { "fillMode", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFillMode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationTable = { 33, 31, JSWebKitAnimationTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitAnimationConstructorTableValues[] =
{
    { "DIRECTION_NORMAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDIRECTION_NORMAL), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DIRECTION_ALTERNATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDIRECTION_ALTERNATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "FILL_NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_NONE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "FILL_BACKWARDS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_BACKWARDS), (intptr_t)0 THUNK_GENERATOR(0) },
    { "FILL_FORWARDS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_FORWARDS), (intptr_t)0 THUNK_GENERATOR(0) },
    { "FILL_BOTH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_BOTH), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationConstructorTable = { 16, 15, JSWebKitAnimationConstructorTableValues, 0 };

COMPILE_ASSERT(0 == WebKitAnimation::DIRECTION_NORMAL, WebKitAnimationEnumDIRECTION_NORMALIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == WebKitAnimation::DIRECTION_ALTERNATE, WebKitAnimationEnumDIRECTION_ALTERNATEIsWrongUseDontCheckEnums);
COMPILE_ASSERT(0 == WebKitAnimation::FILL_NONE, WebKitAnimationEnumFILL_NONEIsWrongUseDontCheckEnums);
COMPILE_ASSERT(1 == WebKitAnimation::FILL_BACKWARDS, WebKitAnimationEnumFILL_BACKWARDSIsWrongUseDontCheckEnums);
COMPILE_ASSERT(2 == WebKitAnimation::FILL_FORWARDS, WebKitAnimationEnumFILL_FORWARDSIsWrongUseDontCheckEnums);
COMPILE_ASSERT(3 == WebKitAnimation::FILL_BOTH, WebKitAnimationEnumFILL_BOTHIsWrongUseDontCheckEnums);

class JSWebKitAnimationConstructor : public DOMConstructorObject {
private:
    JSWebKitAnimationConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSWebKitAnimationConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSWebKitAnimationConstructor* ptr = new (JSC::allocateCell<JSWebKitAnimationConstructor>(*exec->heap())) JSWebKitAnimationConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSWebKitAnimationConstructor::s_info = { "WebKitAnimationConstructor", &DOMConstructorObject::s_info, &JSWebKitAnimationConstructorTable, 0 };

JSWebKitAnimationConstructor::JSWebKitAnimationConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebKitAnimationConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebKitAnimationPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebKitAnimationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebKitAnimationConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationConstructorTable, this, propertyName, slot);
}

bool JSWebKitAnimationConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebKitAnimationConstructor, JSDOMWrapper>(exec, &JSWebKitAnimationConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebKitAnimationPrototypeTableValues[] =
{
    { "DIRECTION_NORMAL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDIRECTION_NORMAL), (intptr_t)0 THUNK_GENERATOR(0) },
    { "DIRECTION_ALTERNATE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationDIRECTION_ALTERNATE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "FILL_NONE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_NONE), (intptr_t)0 THUNK_GENERATOR(0) },
    { "FILL_BACKWARDS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_BACKWARDS), (intptr_t)0 THUNK_GENERATOR(0) },
    { "FILL_FORWARDS", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_FORWARDS), (intptr_t)0 THUNK_GENERATOR(0) },
    { "FILL_BOTH", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebKitAnimationFILL_BOTH), (intptr_t)0 THUNK_GENERATOR(0) },
    { "play", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitAnimationPrototypeFunctionPlay), (intptr_t)0 THUNK_GENERATOR(0) },
    { "pause", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsWebKitAnimationPrototypeFunctionPause), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebKitAnimationPrototypeTable = { 17, 15, JSWebKitAnimationPrototypeTableValues, 0 };
const ClassInfo JSWebKitAnimationPrototype::s_info = { "WebKitAnimationPrototype", &JSC::JSNonFinalObject::s_info, &JSWebKitAnimationPrototypeTable, 0 };

JSObject* JSWebKitAnimationPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebKitAnimation>(exec, globalObject);
}

bool JSWebKitAnimationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSWebKitAnimationPrototype, JSObject>(exec, &JSWebKitAnimationPrototypeTable, this, propertyName, slot);
}

bool JSWebKitAnimationPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSWebKitAnimationPrototype, JSObject>(exec, &JSWebKitAnimationPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSWebKitAnimation::s_info = { "WebKitAnimation", &JSDOMWrapper::s_info, &JSWebKitAnimationTable, 0 };

JSWebKitAnimation::JSWebKitAnimation(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebKitAnimation> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSWebKitAnimation::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebKitAnimation::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebKitAnimationPrototype::create(exec->globalData(), globalObject, JSWebKitAnimationPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSWebKitAnimation::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSWebKitAnimation, Base>(exec, &JSWebKitAnimationTable, this, propertyName, slot);
}

bool JSWebKitAnimation::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSWebKitAnimation, Base>(exec, &JSWebKitAnimationTable, this, propertyName, descriptor);
}

JSValue jsWebKitAnimationName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}


JSValue jsWebKitAnimationDuration(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(imp->duration());
    return result;
}


JSValue jsWebKitAnimationElapsedTime(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(imp->elapsedTime());
    return result;
}


JSValue jsWebKitAnimationDelay(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(imp->delay());
    return result;
}


JSValue jsWebKitAnimationIterationCount(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    return castedThis->iterationCount(exec);
}


JSValue jsWebKitAnimationPaused(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsBoolean(imp->paused());
    return result;
}


JSValue jsWebKitAnimationEnded(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsBoolean(imp->ended());
    return result;
}


JSValue jsWebKitAnimationDirection(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(imp->direction());
    return result;
}


JSValue jsWebKitAnimationFillMode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());
    JSValue result = jsNumber(imp->fillMode());
    return result;
}


JSValue jsWebKitAnimationConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebKitAnimation* domObject = static_cast<JSWebKitAnimation*>(asObject(slotBase));
    return JSWebKitAnimation::getConstructor(exec, domObject->globalObject());
}

void JSWebKitAnimation::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSWebKitAnimation, Base>(exec, propertyName, value, &JSWebKitAnimationTable, this, slot);
}

void setJSWebKitAnimationElapsedTime(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(thisObject);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());
    imp->setElapsedTime(value.toNumber(exec));
}


JSValue JSWebKitAnimation::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebKitAnimationConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsWebKitAnimationPrototypeFunctionPlay(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitAnimation::s_info))
        return throwVMTypeError(exec);
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitAnimation::s_info);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());

    imp->play();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsWebKitAnimationPrototypeFunctionPause(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSWebKitAnimation::s_info))
        return throwVMTypeError(exec);
    JSWebKitAnimation* castedThis = static_cast<JSWebKitAnimation*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSWebKitAnimation::s_info);
    WebKitAnimation* imp = static_cast<WebKitAnimation*>(castedThis->impl());

    imp->pause();
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsWebKitAnimationDIRECTION_NORMAL(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsWebKitAnimationDIRECTION_ALTERNATE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsWebKitAnimationFILL_NONE(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsWebKitAnimationFILL_BACKWARDS(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsWebKitAnimationFILL_FORWARDS(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsWebKitAnimationFILL_BOTH(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebKitAnimation* impl)
{
    return wrap<JSWebKitAnimation>(exec, globalObject, impl);
}

WebKitAnimation* toWebKitAnimation(JSC::JSValue value)
{
    return value.inherits(&JSWebKitAnimation::s_info) ? static_cast<JSWebKitAnimation*>(asObject(value))->impl() : 0;
}

}
