/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLTexture.h"

#include "WebGLTexture.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebGLTexture);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLTextureTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLTextureConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLTextureTable = { 2, 1, JSWebGLTextureTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLTextureConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLTextureConstructorTable = { 1, 0, JSWebGLTextureConstructorTableValues, 0 };
class JSWebGLTextureConstructor : public DOMConstructorObject {
private:
    JSWebGLTextureConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSWebGLTextureConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSWebGLTextureConstructor* ptr = new (JSC::allocateCell<JSWebGLTextureConstructor>(*exec->heap())) JSWebGLTextureConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSWebGLTextureConstructor::s_info = { "WebGLTextureConstructor", &DOMConstructorObject::s_info, &JSWebGLTextureConstructorTable, 0 };

JSWebGLTextureConstructor::JSWebGLTextureConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLTextureConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebGLTexturePrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebGLTextureConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLTextureConstructor, JSDOMWrapper>(exec, &JSWebGLTextureConstructorTable, this, propertyName, slot);
}

bool JSWebGLTextureConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLTextureConstructor, JSDOMWrapper>(exec, &JSWebGLTextureConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLTexturePrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLTexturePrototypeTable = { 1, 0, JSWebGLTexturePrototypeTableValues, 0 };
const ClassInfo JSWebGLTexturePrototype::s_info = { "WebGLTexturePrototype", &JSC::JSNonFinalObject::s_info, &JSWebGLTexturePrototypeTable, 0 };

JSObject* JSWebGLTexturePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLTexture>(exec, globalObject);
}

const ClassInfo JSWebGLTexture::s_info = { "WebGLTexture", &JSDOMWrapper::s_info, &JSWebGLTextureTable, 0 };

JSWebGLTexture::JSWebGLTexture(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLTexture> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSWebGLTexture::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLTexture::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLTexturePrototype::create(exec->globalData(), globalObject, JSWebGLTexturePrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSWebGLTexture::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSWebGLTexture, Base>(exec, &JSWebGLTextureTable, this, propertyName, slot);
}

bool JSWebGLTexture::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSWebGLTexture, Base>(exec, &JSWebGLTextureTable, this, propertyName, descriptor);
}

JSValue jsWebGLTextureConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLTexture* domObject = static_cast<JSWebGLTexture*>(asObject(slotBase));
    return JSWebGLTexture::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLTexture::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLTextureConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLTexture* impl)
{
    return wrap<JSWebGLTexture>(exec, globalObject, impl);
}

WebGLTexture* toWebGLTexture(JSC::JSValue value)
{
    return value.inherits(&JSWebGLTexture::s_info) ? static_cast<JSWebGLTexture*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
