/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLRenderbuffer.h"

#include "WebGLRenderbuffer.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSWebGLRenderbuffer);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLRenderbufferTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLRenderbufferConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLRenderbufferTable = { 2, 1, JSWebGLRenderbufferTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLRenderbufferConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLRenderbufferConstructorTable = { 1, 0, JSWebGLRenderbufferConstructorTableValues, 0 };
class JSWebGLRenderbufferConstructor : public DOMConstructorObject {
private:
    JSWebGLRenderbufferConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSWebGLRenderbufferConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSWebGLRenderbufferConstructor* ptr = new (JSC::allocateCell<JSWebGLRenderbufferConstructor>(*exec->heap())) JSWebGLRenderbufferConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSWebGLRenderbufferConstructor::s_info = { "WebGLRenderbufferConstructor", &DOMConstructorObject::s_info, &JSWebGLRenderbufferConstructorTable, 0 };

JSWebGLRenderbufferConstructor::JSWebGLRenderbufferConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLRenderbufferConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebGLRenderbufferPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSWebGLRenderbufferConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLRenderbufferConstructor, JSDOMWrapper>(exec, &JSWebGLRenderbufferConstructorTable, this, propertyName, slot);
}

bool JSWebGLRenderbufferConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLRenderbufferConstructor, JSDOMWrapper>(exec, &JSWebGLRenderbufferConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSWebGLRenderbufferPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSWebGLRenderbufferPrototypeTable = { 1, 0, JSWebGLRenderbufferPrototypeTableValues, 0 };
const ClassInfo JSWebGLRenderbufferPrototype::s_info = { "WebGLRenderbufferPrototype", &JSC::JSNonFinalObject::s_info, &JSWebGLRenderbufferPrototypeTable, 0 };

JSObject* JSWebGLRenderbufferPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLRenderbuffer>(exec, globalObject);
}

const ClassInfo JSWebGLRenderbuffer::s_info = { "WebGLRenderbuffer", &JSDOMWrapper::s_info, &JSWebGLRenderbufferTable, 0 };

JSWebGLRenderbuffer::JSWebGLRenderbuffer(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLRenderbuffer> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSWebGLRenderbuffer::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLRenderbuffer::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLRenderbufferPrototype::create(exec->globalData(), globalObject, JSWebGLRenderbufferPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSWebGLRenderbuffer::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSWebGLRenderbuffer, Base>(exec, &JSWebGLRenderbufferTable, this, propertyName, slot);
}

bool JSWebGLRenderbuffer::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSWebGLRenderbuffer, Base>(exec, &JSWebGLRenderbufferTable, this, propertyName, descriptor);
}

JSValue jsWebGLRenderbufferConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSWebGLRenderbuffer* domObject = static_cast<JSWebGLRenderbuffer*>(asObject(slotBase));
    return JSWebGLRenderbuffer::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLRenderbuffer::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLRenderbufferConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, WebGLRenderbuffer* impl)
{
    return wrap<JSWebGLRenderbuffer>(exec, globalObject, impl);
}

WebGLRenderbuffer* toWebGLRenderbuffer(JSC::JSValue value)
{
    return value.inherits(&JSWebGLRenderbuffer::s_info) ? static_cast<JSWebGLRenderbuffer*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
