/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGTitleElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGTitleElement.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGTitleElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGTitleElementTableValues[] =
{
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTitleElementXmllang), (intptr_t)setJSSVGTitleElementXmllang THUNK_GENERATOR(0) },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTitleElementXmlspace), (intptr_t)setJSSVGTitleElementXmlspace THUNK_GENERATOR(0) },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTitleElementClassName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTitleElementStyle), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGTitleElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGTitleElementTable = { 16, 15, JSSVGTitleElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGTitleElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGTitleElementConstructorTable = { 1, 0, JSSVGTitleElementConstructorTableValues, 0 };
class JSSVGTitleElementConstructor : public DOMConstructorObject {
private:
    JSSVGTitleElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGTitleElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGTitleElementConstructor* ptr = new (JSC::allocateCell<JSSVGTitleElementConstructor>(*exec->heap())) JSSVGTitleElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGTitleElementConstructor::s_info = { "SVGTitleElementConstructor", &DOMConstructorObject::s_info, &JSSVGTitleElementConstructorTable, 0 };

JSSVGTitleElementConstructor::JSSVGTitleElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGTitleElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGTitleElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGTitleElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGTitleElementConstructor, JSDOMWrapper>(exec, &JSSVGTitleElementConstructorTable, this, propertyName, slot);
}

bool JSSVGTitleElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGTitleElementConstructor, JSDOMWrapper>(exec, &JSSVGTitleElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGTitleElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGTitleElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGTitleElementPrototypeTable = { 2, 1, JSSVGTitleElementPrototypeTableValues, 0 };
const ClassInfo JSSVGTitleElementPrototype::s_info = { "SVGTitleElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGTitleElementPrototypeTable, 0 };

JSObject* JSSVGTitleElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGTitleElement>(exec, globalObject);
}

bool JSSVGTitleElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGTitleElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGTitleElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGTitleElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGTitleElement::s_info = { "SVGTitleElement", &JSSVGElement::s_info, &JSSVGTitleElementTable, 0 };

JSSVGTitleElement::JSSVGTitleElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGTitleElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGTitleElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGTitleElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGTitleElementPrototype::create(exec->globalData(), globalObject, JSSVGTitleElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGTitleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGTitleElement, Base>(exec, &JSSVGTitleElementTable, this, propertyName, slot);
}

bool JSSVGTitleElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGTitleElement, Base>(exec, &JSSVGTitleElementTable, this, propertyName, descriptor);
}

JSValue jsSVGTitleElementXmllang(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTitleElement* castedThis = static_cast<JSSVGTitleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTitleElement* imp = static_cast<SVGTitleElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmllang());
    return result;
}


JSValue jsSVGTitleElementXmlspace(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTitleElement* castedThis = static_cast<JSSVGTitleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTitleElement* imp = static_cast<SVGTitleElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmlspace());
    return result;
}


JSValue jsSVGTitleElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTitleElement* castedThis = static_cast<JSSVGTitleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTitleElement* imp = static_cast<SVGTitleElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGTitleElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTitleElement* castedThis = static_cast<JSSVGTitleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGTitleElement* imp = static_cast<SVGTitleElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}


JSValue jsSVGTitleElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGTitleElement* domObject = static_cast<JSSVGTitleElement*>(asObject(slotBase));
    return JSSVGTitleElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGTitleElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSSVGTitleElement, Base>(exec, propertyName, value, &JSSVGTitleElementTable, this, slot);
}

void setJSSVGTitleElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGTitleElement* castedThis = static_cast<JSSVGTitleElement*>(thisObject);
    SVGTitleElement* imp = static_cast<SVGTitleElement*>(castedThis->impl());
    imp->setXmllang(ustringToString(value.toString(exec)));
}


void setJSSVGTitleElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGTitleElement* castedThis = static_cast<JSSVGTitleElement*>(thisObject);
    SVGTitleElement* imp = static_cast<SVGTitleElement*>(castedThis->impl());
    imp->setXmlspace(ustringToString(value.toString(exec)));
}


JSValue JSSVGTitleElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGTitleElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGTitleElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGTitleElement::s_info))
        return throwVMTypeError(exec);
    JSSVGTitleElement* castedThis = static_cast<JSSVGTitleElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGTitleElement::s_info);
    SVGTitleElement* imp = static_cast<SVGTitleElement*>(castedThis->impl());
    const String& name(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
