/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGRectElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGRectElement.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGRectElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGRectElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementWidth), (intptr_t)0 THUNK_GENERATOR(0) },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementHeight), (intptr_t)0 THUNK_GENERATOR(0) },
    { "rx", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRx), (intptr_t)0 THUNK_GENERATOR(0) },
    { "ry", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRy), (intptr_t)0 THUNK_GENERATOR(0) },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRequiredFeatures), (intptr_t)0 THUNK_GENERATOR(0) },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRequiredExtensions), (intptr_t)0 THUNK_GENERATOR(0) },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementSystemLanguage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementXmllang), (intptr_t)setJSSVGRectElementXmllang THUNK_GENERATOR(0) },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementXmlspace), (intptr_t)setJSSVGRectElementXmlspace THUNK_GENERATOR(0) },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementExternalResourcesRequired), (intptr_t)0 THUNK_GENERATOR(0) },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementClassName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementStyle), (intptr_t)0 THUNK_GENERATOR(0) },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementTransform), (intptr_t)0 THUNK_GENERATOR(0) },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementNearestViewportElement), (intptr_t)0 THUNK_GENERATOR(0) },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementFarthestViewportElement), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGRectElementTable = { 69, 63, JSSVGRectElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGRectElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGRectElementConstructorTable = { 1, 0, JSSVGRectElementConstructorTableValues, 0 };
class JSSVGRectElementConstructor : public DOMConstructorObject {
private:
    JSSVGRectElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGRectElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGRectElementConstructor* ptr = new (JSC::allocateCell<JSSVGRectElementConstructor>(*exec->heap())) JSSVGRectElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGRectElementConstructor::s_info = { "SVGRectElementConstructor", &DOMConstructorObject::s_info, &JSSVGRectElementConstructorTable, 0 };

JSSVGRectElementConstructor::JSSVGRectElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGRectElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGRectElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGRectElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRectElementConstructor, JSDOMWrapper>(exec, &JSSVGRectElementConstructorTable, this, propertyName, slot);
}

bool JSSVGRectElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGRectElementConstructor, JSDOMWrapper>(exec, &JSSVGRectElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGRectElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionHasExtension), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getPresentationAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 THUNK_GENERATOR(0) },
    { "getBBox", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetBBox), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getCTM", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetCTM), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getScreenCTM", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetScreenCTM), (intptr_t)0 THUNK_GENERATOR(0) },
    { "getTransformToElement", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetTransformToElement), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGRectElementPrototypeTable = { 17, 15, JSSVGRectElementPrototypeTableValues, 0 };
const ClassInfo JSSVGRectElementPrototype::s_info = { "SVGRectElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGRectElementPrototypeTable, 0 };

JSObject* JSSVGRectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGRectElement>(exec, globalObject);
}

bool JSSVGRectElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGRectElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGRectElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGRectElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGRectElement::s_info = { "SVGRectElement", &JSSVGElement::s_info, &JSSVGRectElementTable, 0 };

JSSVGRectElement::JSSVGRectElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGRectElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGRectElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGRectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGRectElementPrototype::create(exec->globalData(), globalObject, JSSVGRectElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGRectElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGRectElement, Base>(exec, &JSSVGRectElementTable, this, propertyName, slot);
}

bool JSSVGRectElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGRectElement, Base>(exec, &JSSVGRectElementTable, this, propertyName, descriptor);
}

JSValue jsSVGRectElementX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementHeight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementRx(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->rxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementRy(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->ryAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementRequiredFeatures(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(imp, imp->requiredFeatures())));
    return result;
}


JSValue jsSVGRectElementRequiredExtensions(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(imp, imp->requiredExtensions())));
    return result;
}


JSValue jsSVGRectElementSystemLanguage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(imp, imp->systemLanguage())));
    return result;
}


JSValue jsSVGRectElementXmllang(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmllang());
    return result;
}


JSValue jsSVGRectElementXmlspace(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmlspace());
    return result;
}


JSValue jsSVGRectElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}


JSValue jsSVGRectElementTransform(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementNearestViewportElement(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nearestViewportElement()));
    return result;
}


JSValue jsSVGRectElementFarthestViewportElement(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->farthestViewportElement()));
    return result;
}


JSValue jsSVGRectElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGRectElement* domObject = static_cast<JSSVGRectElement*>(asObject(slotBase));
    return JSSVGRectElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGRectElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSSVGRectElement, Base>(exec, propertyName, value, &JSSVGRectElementTable, this, slot);
}

void setJSSVGRectElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(thisObject);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    imp->setXmllang(ustringToString(value.toString(exec)));
}


void setJSSVGRectElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(thisObject);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    imp->setXmlspace(ustringToString(value.toString(exec)));
}


JSValue JSSVGRectElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGRectElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    const String& extension(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    const String& name(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(imp->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(imp->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(imp->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = static_cast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* imp = static_cast<SVGRectElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(exec->argument(0)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(imp->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
