/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(SVG_FONTS)

#include "JSSVGGlyphRefElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGGlyphRefElement.h"
#include "SVGNames.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGGlyphRefElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGGlyphRefElementTableValues[] =
{
    { "glyphRef", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementGlyphRef), (intptr_t)setJSSVGGlyphRefElementGlyphRef THUNK_GENERATOR(0) },
    { "format", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementFormat), (intptr_t)setJSSVGGlyphRefElementFormat THUNK_GENERATOR(0) },
    { "x", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementX), (intptr_t)setJSSVGGlyphRefElementX THUNK_GENERATOR(0) },
    { "y", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementY), (intptr_t)setJSSVGGlyphRefElementY THUNK_GENERATOR(0) },
    { "dx", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementDx), (intptr_t)setJSSVGGlyphRefElementDx THUNK_GENERATOR(0) },
    { "dy", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementDy), (intptr_t)setJSSVGGlyphRefElementDy THUNK_GENERATOR(0) },
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementHref), (intptr_t)0 THUNK_GENERATOR(0) },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementClassName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementStyle), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGGlyphRefElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGGlyphRefElementTable = { 33, 31, JSSVGGlyphRefElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGGlyphRefElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGGlyphRefElementConstructorTable = { 1, 0, JSSVGGlyphRefElementConstructorTableValues, 0 };
class JSSVGGlyphRefElementConstructor : public DOMConstructorObject {
private:
    JSSVGGlyphRefElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGGlyphRefElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGGlyphRefElementConstructor* ptr = new (JSC::allocateCell<JSSVGGlyphRefElementConstructor>(*exec->heap())) JSSVGGlyphRefElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGGlyphRefElementConstructor::s_info = { "SVGGlyphRefElementConstructor", &DOMConstructorObject::s_info, &JSSVGGlyphRefElementConstructorTable, 0 };

JSSVGGlyphRefElementConstructor::JSSVGGlyphRefElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGGlyphRefElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGGlyphRefElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGGlyphRefElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGGlyphRefElementConstructor, JSDOMWrapper>(exec, &JSSVGGlyphRefElementConstructorTable, this, propertyName, slot);
}

bool JSSVGGlyphRefElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGGlyphRefElementConstructor, JSDOMWrapper>(exec, &JSSVGGlyphRefElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGGlyphRefElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGGlyphRefElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGGlyphRefElementPrototypeTable = { 2, 1, JSSVGGlyphRefElementPrototypeTableValues, 0 };
const ClassInfo JSSVGGlyphRefElementPrototype::s_info = { "SVGGlyphRefElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGGlyphRefElementPrototypeTable, 0 };

JSObject* JSSVGGlyphRefElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGGlyphRefElement>(exec, globalObject);
}

bool JSSVGGlyphRefElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGGlyphRefElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGGlyphRefElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGGlyphRefElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGGlyphRefElement::s_info = { "SVGGlyphRefElement", &JSSVGElement::s_info, &JSSVGGlyphRefElementTable, 0 };

JSSVGGlyphRefElement::JSSVGGlyphRefElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGGlyphRefElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGGlyphRefElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGGlyphRefElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGGlyphRefElementPrototype::create(exec->globalData(), globalObject, JSSVGGlyphRefElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGGlyphRefElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGGlyphRefElement, Base>(exec, &JSSVGGlyphRefElementTable, this, propertyName, slot);
}

bool JSSVGGlyphRefElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGGlyphRefElement, Base>(exec, &JSSVGGlyphRefElementTable, this, propertyName, descriptor);
}

JSValue jsSVGGlyphRefElementGlyphRef(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->glyphRef());
    return result;
}


JSValue jsSVGGlyphRefElementFormat(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getAttribute(WebCore::SVGNames::formatAttr));
    return result;
}


JSValue jsSVGGlyphRefElementX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->x());
    return result;
}


JSValue jsSVGGlyphRefElementY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->y());
    return result;
}


JSValue jsSVGGlyphRefElementDx(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->dx());
    return result;
}


JSValue jsSVGGlyphRefElementDy(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->dy());
    return result;
}


JSValue jsSVGGlyphRefElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGlyphRefElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGGlyphRefElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}


JSValue jsSVGGlyphRefElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGGlyphRefElement* domObject = static_cast<JSSVGGlyphRefElement*>(asObject(slotBase));
    return JSSVGGlyphRefElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGGlyphRefElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSSVGGlyphRefElement, Base>(exec, propertyName, value, &JSSVGGlyphRefElementTable, this, slot);
}

void setJSSVGGlyphRefElementGlyphRef(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(thisObject);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setGlyphRef(ustringToString(value.toString(exec)), ec);
    setDOMException(exec, ec);
}


void setJSSVGGlyphRefElementFormat(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(thisObject);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setAttribute(WebCore::SVGNames::formatAttr, valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}


void setJSSVGGlyphRefElementX(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(thisObject);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setX(value.toFloat(exec), ec);
    setDOMException(exec, ec);
}


void setJSSVGGlyphRefElementY(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(thisObject);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setY(value.toFloat(exec), ec);
    setDOMException(exec, ec);
}


void setJSSVGGlyphRefElementDx(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(thisObject);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setDx(value.toFloat(exec), ec);
    setDOMException(exec, ec);
}


void setJSSVGGlyphRefElementDy(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(thisObject);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    imp->setDy(value.toFloat(exec), ec);
    setDOMException(exec, ec);
}


JSValue JSSVGGlyphRefElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGGlyphRefElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGGlyphRefElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGGlyphRefElement::s_info))
        return throwVMTypeError(exec);
    JSSVGGlyphRefElement* castedThis = static_cast<JSSVGGlyphRefElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGGlyphRefElement::s_info);
    SVGGlyphRefElement* imp = static_cast<SVGGlyphRefElement*>(castedThis->impl());
    const String& name(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG) && ENABLE(SVG_FONTS)
