/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFEImageElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGFEImageElement.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEImageElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGFEImageElementTableValues[] =
{
    { "preserveAspectRatio", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementPreserveAspectRatio), (intptr_t)0 THUNK_GENERATOR(0) },
    { "href", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementHref), (intptr_t)0 THUNK_GENERATOR(0) },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementXmllang), (intptr_t)setJSSVGFEImageElementXmllang THUNK_GENERATOR(0) },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementXmlspace), (intptr_t)setJSSVGFEImageElementXmlspace THUNK_GENERATOR(0) },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementExternalResourcesRequired), (intptr_t)0 THUNK_GENERATOR(0) },
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementX), (intptr_t)0 THUNK_GENERATOR(0) },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementY), (intptr_t)0 THUNK_GENERATOR(0) },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementWidth), (intptr_t)0 THUNK_GENERATOR(0) },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementHeight), (intptr_t)0 THUNK_GENERATOR(0) },
    { "result", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementResult), (intptr_t)0 THUNK_GENERATOR(0) },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementClassName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementStyle), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGFEImageElementTable = { 33, 31, JSSVGFEImageElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGFEImageElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGFEImageElementConstructorTable = { 1, 0, JSSVGFEImageElementConstructorTableValues, 0 };
class JSSVGFEImageElementConstructor : public DOMConstructorObject {
private:
    JSSVGFEImageElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSSVGFEImageElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSSVGFEImageElementConstructor* ptr = new (JSC::allocateCell<JSSVGFEImageElementConstructor>(*exec->heap())) JSSVGFEImageElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGFEImageElementConstructor::s_info = { "SVGFEImageElementConstructor", &DOMConstructorObject::s_info, &JSSVGFEImageElementConstructorTable, 0 };

JSSVGFEImageElementConstructor::JSSVGFEImageElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEImageElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFEImageElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFEImageElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEImageElementConstructor, JSDOMWrapper>(exec, &JSSVGFEImageElementConstructorTable, this, propertyName, slot);
}

bool JSSVGFEImageElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEImageElementConstructor, JSDOMWrapper>(exec, &JSSVGFEImageElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSSVGFEImageElementPrototypeTableValues[] =
{
    { "getPresentationAttribute", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsSVGFEImageElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSSVGFEImageElementPrototypeTable = { 2, 1, JSSVGFEImageElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEImageElementPrototype::s_info = { "SVGFEImageElementPrototype", &JSC::JSNonFinalObject::s_info, &JSSVGFEImageElementPrototypeTable, 0 };

JSObject* JSSVGFEImageElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEImageElement>(exec, globalObject);
}

bool JSSVGFEImageElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEImageElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGFEImageElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFEImageElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGFEImageElement::s_info = { "SVGFEImageElement", &JSSVGElement::s_info, &JSSVGFEImageElementTable, 0 };

JSSVGFEImageElement::JSSVGFEImageElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEImageElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFEImageElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEImageElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEImageElementPrototype::create(exec->globalData(), globalObject, JSSVGFEImageElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEImageElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSSVGFEImageElement, Base>(exec, &JSSVGFEImageElementTable, this, propertyName, slot);
}

bool JSSVGFEImageElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSSVGFEImageElement, Base>(exec, &JSSVGFEImageElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFEImageElementPreserveAspectRatio(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEImageElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEImageElementXmllang(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmllang());
    return result;
}


JSValue jsSVGFEImageElementXmlspace(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmlspace());
    return result;
}


JSValue jsSVGFEImageElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEImageElementX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEImageElementY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEImageElementWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEImageElementHeight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEImageElementResult(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEImageElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEImageElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}


JSValue jsSVGFEImageElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* domObject = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    return JSSVGFEImageElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGFEImageElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSSVGFEImageElement, Base>(exec, propertyName, value, &JSSVGFEImageElementTable, this, slot);
}

void setJSSVGFEImageElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(thisObject);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    imp->setXmllang(ustringToString(value.toString(exec)));
}


void setJSSVGFEImageElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(thisObject);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    imp->setXmlspace(ustringToString(value.toString(exec)));
}


JSValue JSSVGFEImageElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEImageElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGFEImageElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGFEImageElement::s_info))
        return throwVMTypeError(exec);
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGFEImageElement::s_info);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    const String& name(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
