/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(BLOB) || ENABLE(FILE_SYSTEM)

#include "JSOperationNotAllowedException.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include "OperationNotAllowedException.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSOperationNotAllowedException);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSOperationNotAllowedExceptionTableValues[] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOperationNotAllowedExceptionCode), (intptr_t)0 THUNK_GENERATOR(0) },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOperationNotAllowedExceptionName), (intptr_t)0 THUNK_GENERATOR(0) },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOperationNotAllowedExceptionMessage), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOperationNotAllowedExceptionConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSOperationNotAllowedExceptionTable = { 10, 7, JSOperationNotAllowedExceptionTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSOperationNotAllowedExceptionConstructorTableValues[] =
{
    { "NOT_ALLOWED_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOperationNotAllowedExceptionNOT_ALLOWED_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSOperationNotAllowedExceptionConstructorTable = { 2, 1, JSOperationNotAllowedExceptionConstructorTableValues, 0 };
class JSOperationNotAllowedExceptionConstructor : public DOMConstructorObject {
private:
    JSOperationNotAllowedExceptionConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSOperationNotAllowedExceptionConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSOperationNotAllowedExceptionConstructor* ptr = new (JSC::allocateCell<JSOperationNotAllowedExceptionConstructor>(*exec->heap())) JSOperationNotAllowedExceptionConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSOperationNotAllowedExceptionConstructor::s_info = { "OperationNotAllowedExceptionConstructor", &DOMConstructorObject::s_info, &JSOperationNotAllowedExceptionConstructorTable, 0 };

JSOperationNotAllowedExceptionConstructor::JSOperationNotAllowedExceptionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSOperationNotAllowedExceptionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSOperationNotAllowedExceptionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSOperationNotAllowedExceptionConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSOperationNotAllowedExceptionConstructor, JSDOMWrapper>(exec, &JSOperationNotAllowedExceptionConstructorTable, this, propertyName, slot);
}

bool JSOperationNotAllowedExceptionConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSOperationNotAllowedExceptionConstructor, JSDOMWrapper>(exec, &JSOperationNotAllowedExceptionConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSOperationNotAllowedExceptionPrototypeTableValues[] =
{
    { "NOT_ALLOWED_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsOperationNotAllowedExceptionNOT_ALLOWED_ERR), (intptr_t)0 THUNK_GENERATOR(0) },
    { "toString", DontDelete | DontEnum | Function, (intptr_t)static_cast<NativeFunction>(jsOperationNotAllowedExceptionPrototypeFunctionToString), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSOperationNotAllowedExceptionPrototypeTable = { 4, 3, JSOperationNotAllowedExceptionPrototypeTableValues, 0 };
static const HashTable* getJSOperationNotAllowedExceptionPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSOperationNotAllowedExceptionPrototypeTable);
}

const ClassInfo JSOperationNotAllowedExceptionPrototype::s_info = { "OperationNotAllowedExceptionPrototype", &JSC::JSNonFinalObject::s_info, 0, getJSOperationNotAllowedExceptionPrototypeTable };

JSObject* JSOperationNotAllowedExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOperationNotAllowedException>(exec, globalObject);
}

bool JSOperationNotAllowedExceptionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticPropertySlot<JSOperationNotAllowedExceptionPrototype, JSObject>(exec, getJSOperationNotAllowedExceptionPrototypeTable(exec), this, propertyName, slot);
}

bool JSOperationNotAllowedExceptionPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticPropertyDescriptor<JSOperationNotAllowedExceptionPrototype, JSObject>(exec, getJSOperationNotAllowedExceptionPrototypeTable(exec), this, propertyName, descriptor);
}

static const HashTable* getJSOperationNotAllowedExceptionTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSOperationNotAllowedExceptionTable);
}

const ClassInfo JSOperationNotAllowedException::s_info = { "OperationNotAllowedException", &JSDOMWrapper::s_info, 0, getJSOperationNotAllowedExceptionTable };

JSOperationNotAllowedException::JSOperationNotAllowedException(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<OperationNotAllowedException> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSOperationNotAllowedException::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSOperationNotAllowedException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSOperationNotAllowedExceptionPrototype::create(exec->globalData(), globalObject, JSOperationNotAllowedExceptionPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSOperationNotAllowedException::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSOperationNotAllowedException, Base>(exec, getJSOperationNotAllowedExceptionTable(exec), this, propertyName, slot);
}

bool JSOperationNotAllowedException::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSOperationNotAllowedException, Base>(exec, getJSOperationNotAllowedExceptionTable(exec), this, propertyName, descriptor);
}

JSValue jsOperationNotAllowedExceptionCode(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSOperationNotAllowedException* castedThis = static_cast<JSOperationNotAllowedException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OperationNotAllowedException* imp = static_cast<OperationNotAllowedException*>(castedThis->impl());
    JSValue result = jsNumber(imp->code());
    return result;
}


JSValue jsOperationNotAllowedExceptionName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSOperationNotAllowedException* castedThis = static_cast<JSOperationNotAllowedException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OperationNotAllowedException* imp = static_cast<OperationNotAllowedException*>(castedThis->impl());
    JSValue result = jsString(exec, imp->name());
    return result;
}


JSValue jsOperationNotAllowedExceptionMessage(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSOperationNotAllowedException* castedThis = static_cast<JSOperationNotAllowedException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    OperationNotAllowedException* imp = static_cast<OperationNotAllowedException*>(castedThis->impl());
    JSValue result = jsString(exec, imp->message());
    return result;
}


JSValue jsOperationNotAllowedExceptionConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSOperationNotAllowedException* domObject = static_cast<JSOperationNotAllowedException*>(asObject(slotBase));
    return JSOperationNotAllowedException::getConstructor(exec, domObject->globalObject());
}

JSValue JSOperationNotAllowedException::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSOperationNotAllowedExceptionConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsOperationNotAllowedExceptionPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSOperationNotAllowedException::s_info))
        return throwVMTypeError(exec);
    JSOperationNotAllowedException* castedThis = static_cast<JSOperationNotAllowedException*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSOperationNotAllowedException::s_info);
    OperationNotAllowedException* imp = static_cast<OperationNotAllowedException*>(castedThis->impl());


    JSC::JSValue result = jsString(exec, imp->toString());
    return JSValue::encode(result);
}

// Constant getters

JSValue jsOperationNotAllowedExceptionNOT_ALLOWED_ERR(ExecState* exec, JSValue, const Identifier&)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, OperationNotAllowedException* impl)
{
    return wrap<JSOperationNotAllowedException>(exec, globalObject, impl);
}

OperationNotAllowedException* toOperationNotAllowedException(JSC::JSValue value)
{
    return value.inherits(&JSOperationNotAllowedException::s_info) ? static_cast<JSOperationNotAllowedException*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(BLOB) || ENABLE(FILE_SYSTEM)
