/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(NOTIFICATIONS)

#include "JSNotificationCenter.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "JSNotification.h"
#include "Notification.h"
#include "NotificationCenter.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSNotificationCenter);

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSNotificationCenterPrototypeTableValues[] =
{
    { "createHTMLNotification", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsNotificationCenterPrototypeFunctionCreateHTMLNotification), (intptr_t)1 THUNK_GENERATOR(0) },
    { "createNotification", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsNotificationCenterPrototypeFunctionCreateNotification), (intptr_t)3 THUNK_GENERATOR(0) },
    { "checkPermission", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsNotificationCenterPrototypeFunctionCheckPermission), (intptr_t)0 THUNK_GENERATOR(0) },
    { "requestPermission", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsNotificationCenterPrototypeFunctionRequestPermission), (intptr_t)1 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSNotificationCenterPrototypeTable = { 8, 7, JSNotificationCenterPrototypeTableValues, 0 };
const ClassInfo JSNotificationCenterPrototype::s_info = { "NotificationCenterPrototype", &JSC::JSNonFinalObject::s_info, &JSNotificationCenterPrototypeTable, 0 };

JSObject* JSNotificationCenterPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNotificationCenter>(exec, globalObject);
}

bool JSNotificationCenterPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSNotificationCenterPrototypeTable, this, propertyName, slot);
}

bool JSNotificationCenterPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSNotificationCenterPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSNotificationCenter::s_info = { "NotificationCenter", &JSDOMWrapper::s_info, 0, 0 };

JSNotificationCenter::JSNotificationCenter(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<NotificationCenter> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSNotificationCenter::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSNotificationCenter::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSNotificationCenterPrototype::create(exec->globalData(), globalObject, JSNotificationCenterPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

EncodedJSValue JSC_HOST_CALL jsNotificationCenterPrototypeFunctionCreateHTMLNotification(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotificationCenter::s_info))
        return throwVMTypeError(exec);
    JSNotificationCenter* castedThis = static_cast<JSNotificationCenter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotificationCenter::s_info);
    NotificationCenter* imp = static_cast<NotificationCenter*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& url(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createHTMLNotification(url, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNotificationCenterPrototypeFunctionCreateNotification(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotificationCenter::s_info))
        return throwVMTypeError(exec);
    JSNotificationCenter* castedThis = static_cast<JSNotificationCenter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotificationCenter::s_info);
    NotificationCenter* imp = static_cast<NotificationCenter*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createTypeError(exec, "Not enough arguments"));
    ExceptionCode ec = 0;
    const String& iconUrl(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& title(ustringToString(exec->argument(1).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& body(ustringToString(exec->argument(2).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());


    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->createNotification(iconUrl, title, body, ec)));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNotificationCenterPrototypeFunctionCheckPermission(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotificationCenter::s_info))
        return throwVMTypeError(exec);
    JSNotificationCenter* castedThis = static_cast<JSNotificationCenter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotificationCenter::s_info);
    NotificationCenter* imp = static_cast<NotificationCenter*>(castedThis->impl());


    JSC::JSValue result = jsNumber(imp->checkPermission());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNotificationCenterPrototypeFunctionRequestPermission(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNotificationCenter::s_info))
        return throwVMTypeError(exec);
    JSNotificationCenter* castedThis = static_cast<JSNotificationCenter*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNotificationCenter::s_info);
    return JSValue::encode(castedThis->requestPermission(exec));
}

static inline bool isObservable(JSNotificationCenter* jsNotificationCenter)
{
    if (jsNotificationCenter->hasCustomProperties())
        return true;
    return false;
}

bool JSNotificationCenterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSNotificationCenter* jsNotificationCenter = static_cast<JSNotificationCenter*>(handle.get().asCell());
    if (jsNotificationCenter->impl()->hasPendingActivity())
        return true;
    if (!isObservable(jsNotificationCenter))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSNotificationCenterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSNotificationCenter* jsNotificationCenter = static_cast<JSNotificationCenter*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNotificationCenter->impl(), jsNotificationCenter);
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, NotificationCenter* impl)
{
    return wrap<JSNotificationCenter>(exec, globalObject, impl);
}

NotificationCenter* toNotificationCenter(JSC::JSValue value)
{
    return value.inherits(&JSNotificationCenter::s_info) ? static_cast<JSNotificationCenter*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(NOTIFICATIONS)
