/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSMediaStreamTrack.h"

#include "KURL.h"
#include "MediaStreamTrack.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSMediaStreamTrack);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMediaStreamTrackTableValues[] =
{
    { "kind", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackKind), (intptr_t)0 THUNK_GENERATOR(0) },
    { "label", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackLabel), (intptr_t)0 THUNK_GENERATOR(0) },
    { "enabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackEnabled), (intptr_t)setJSMediaStreamTrackEnabled THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsMediaStreamTrackConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMediaStreamTrackTable = { 9, 7, JSMediaStreamTrackTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMediaStreamTrackConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMediaStreamTrackConstructorTable = { 1, 0, JSMediaStreamTrackConstructorTableValues, 0 };
class JSMediaStreamTrackConstructor : public DOMConstructorObject {
private:
    JSMediaStreamTrackConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSMediaStreamTrackConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSMediaStreamTrackConstructor* ptr = new (JSC::allocateCell<JSMediaStreamTrackConstructor>(*exec->heap())) JSMediaStreamTrackConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSMediaStreamTrackConstructor::s_info = { "MediaStreamTrackConstructor", &DOMConstructorObject::s_info, &JSMediaStreamTrackConstructorTable, 0 };

JSMediaStreamTrackConstructor::JSMediaStreamTrackConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSMediaStreamTrackConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSMediaStreamTrackPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSMediaStreamTrackConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSMediaStreamTrackConstructor, JSDOMWrapper>(exec, &JSMediaStreamTrackConstructorTable, this, propertyName, slot);
}

bool JSMediaStreamTrackConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSMediaStreamTrackConstructor, JSDOMWrapper>(exec, &JSMediaStreamTrackConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSMediaStreamTrackPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSMediaStreamTrackPrototypeTable = { 1, 0, JSMediaStreamTrackPrototypeTableValues, 0 };
const ClassInfo JSMediaStreamTrackPrototype::s_info = { "MediaStreamTrackPrototype", &JSC::JSNonFinalObject::s_info, &JSMediaStreamTrackPrototypeTable, 0 };

JSObject* JSMediaStreamTrackPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSMediaStreamTrack>(exec, globalObject);
}

const ClassInfo JSMediaStreamTrack::s_info = { "MediaStreamTrack", &JSDOMWrapper::s_info, &JSMediaStreamTrackTable, 0 };

JSMediaStreamTrack::JSMediaStreamTrack(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<MediaStreamTrack> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl)
{
}

void JSMediaStreamTrack::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSMediaStreamTrack::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSMediaStreamTrackPrototype::create(exec->globalData(), globalObject, JSMediaStreamTrackPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

bool JSMediaStreamTrack::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSMediaStreamTrack, Base>(exec, &JSMediaStreamTrackTable, this, propertyName, slot);
}

bool JSMediaStreamTrack::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSMediaStreamTrack, Base>(exec, &JSMediaStreamTrackTable, this, propertyName, descriptor);
}

JSValue jsMediaStreamTrackKind(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMediaStreamTrack* castedThis = static_cast<JSMediaStreamTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaStreamTrack* imp = static_cast<MediaStreamTrack*>(castedThis->impl());
    JSValue result = jsString(exec, imp->kind());
    return result;
}


JSValue jsMediaStreamTrackLabel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMediaStreamTrack* castedThis = static_cast<JSMediaStreamTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaStreamTrack* imp = static_cast<MediaStreamTrack*>(castedThis->impl());
    JSValue result = jsString(exec, imp->label());
    return result;
}


JSValue jsMediaStreamTrackEnabled(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMediaStreamTrack* castedThis = static_cast<JSMediaStreamTrack*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    MediaStreamTrack* imp = static_cast<MediaStreamTrack*>(castedThis->impl());
    JSValue result = jsBoolean(imp->enabled());
    return result;
}


JSValue jsMediaStreamTrackConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSMediaStreamTrack* domObject = static_cast<JSMediaStreamTrack*>(asObject(slotBase));
    return JSMediaStreamTrack::getConstructor(exec, domObject->globalObject());
}

void JSMediaStreamTrack::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSMediaStreamTrack, Base>(exec, propertyName, value, &JSMediaStreamTrackTable, this, slot);
}

void setJSMediaStreamTrackEnabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSMediaStreamTrack* castedThis = static_cast<JSMediaStreamTrack*>(thisObject);
    MediaStreamTrack* imp = static_cast<MediaStreamTrack*>(castedThis->impl());
    imp->setEnabled(value.toBoolean(exec));
}


JSValue JSMediaStreamTrack::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSMediaStreamTrackConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, MediaStreamTrack* impl)
{
    return wrap<JSMediaStreamTrack>(exec, globalObject, impl);
}

MediaStreamTrack* toMediaStreamTrack(JSC::JSValue value)
{
    return value.inherits(&JSMediaStreamTrack::s_info) ? static_cast<JSMediaStreamTrack*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MEDIA_STREAM)
