/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(MEDIA_STREAM)

#include "JSLocalMediaStream.h"

#include "ExceptionCode.h"
#include "JSDOMBinding.h"
#include "LocalMediaStream.h"
#include <runtime/Error.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSLocalMediaStream);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSLocalMediaStreamTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsLocalMediaStreamConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSLocalMediaStreamTable = { 2, 1, JSLocalMediaStreamTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSLocalMediaStreamConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSLocalMediaStreamConstructorTable = { 1, 0, JSLocalMediaStreamConstructorTableValues, 0 };
class JSLocalMediaStreamConstructor : public DOMConstructorObject {
private:
    JSLocalMediaStreamConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSLocalMediaStreamConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSLocalMediaStreamConstructor* ptr = new (JSC::allocateCell<JSLocalMediaStreamConstructor>(*exec->heap())) JSLocalMediaStreamConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSLocalMediaStreamConstructor::s_info = { "LocalMediaStreamConstructor", &DOMConstructorObject::s_info, &JSLocalMediaStreamConstructorTable, 0 };

JSLocalMediaStreamConstructor::JSLocalMediaStreamConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSLocalMediaStreamConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSLocalMediaStreamPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSLocalMediaStreamConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSLocalMediaStreamConstructor, JSDOMWrapper>(exec, &JSLocalMediaStreamConstructorTable, this, propertyName, slot);
}

bool JSLocalMediaStreamConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSLocalMediaStreamConstructor, JSDOMWrapper>(exec, &JSLocalMediaStreamConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSLocalMediaStreamPrototypeTableValues[] =
{
    { "stop", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsLocalMediaStreamPrototypeFunctionStop), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSLocalMediaStreamPrototypeTable = { 2, 1, JSLocalMediaStreamPrototypeTableValues, 0 };
const ClassInfo JSLocalMediaStreamPrototype::s_info = { "LocalMediaStreamPrototype", &JSC::JSNonFinalObject::s_info, &JSLocalMediaStreamPrototypeTable, 0 };

JSObject* JSLocalMediaStreamPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSLocalMediaStream>(exec, globalObject);
}

bool JSLocalMediaStreamPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSLocalMediaStreamPrototypeTable, this, propertyName, slot);
}

bool JSLocalMediaStreamPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSLocalMediaStreamPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSLocalMediaStream::s_info = { "LocalMediaStream", &JSMediaStream::s_info, &JSLocalMediaStreamTable, 0 };

JSLocalMediaStream::JSLocalMediaStream(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<LocalMediaStream> impl)
    : JSMediaStream(structure, globalObject, impl)
{
}

void JSLocalMediaStream::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSLocalMediaStream::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSLocalMediaStreamPrototype::create(exec->globalData(), globalObject, JSLocalMediaStreamPrototype::createStructure(exec->globalData(), globalObject, JSMediaStreamPrototype::self(exec, globalObject)));
}

bool JSLocalMediaStream::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSLocalMediaStream, Base>(exec, &JSLocalMediaStreamTable, this, propertyName, slot);
}

bool JSLocalMediaStream::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSLocalMediaStream, Base>(exec, &JSLocalMediaStreamTable, this, propertyName, descriptor);
}

JSValue jsLocalMediaStreamConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSLocalMediaStream* domObject = static_cast<JSLocalMediaStream*>(asObject(slotBase));
    return JSLocalMediaStream::getConstructor(exec, domObject->globalObject());
}

JSValue JSLocalMediaStream::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSLocalMediaStreamConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsLocalMediaStreamPrototypeFunctionStop(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSLocalMediaStream::s_info))
        return throwVMTypeError(exec);
    JSLocalMediaStream* castedThis = static_cast<JSLocalMediaStream*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSLocalMediaStream::s_info);
    LocalMediaStream* imp = static_cast<LocalMediaStream*>(castedThis->impl());

    imp->stop();
    return JSValue::encode(jsUndefined());
}

void JSLocalMediaStream::visitChildren(SlotVisitor& visitor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    COMPILE_ASSERT(StructureFlags & OverridesVisitChildren, OverridesVisitChildrenWithoutSettingFlag);
    ASSERT(structure()->typeInfo().overridesVisitChildren());
    Base::visitChildren(visitor);
    impl()->visitJSEventListeners(visitor);
}

LocalMediaStream* toLocalMediaStream(JSC::JSValue value)
{
    return value.inherits(&JSLocalMediaStream::s_info) ? static_cast<JSLocalMediaStream*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(MEDIA_STREAM)
