/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSInjectedScriptHost_h
#define JSInjectedScriptHost_h

#if ENABLE(INSPECTOR)

#include "InjectedScriptHost.h"
#include "JSDOMBinding.h"
#include <runtime/JSGlobalObject.h>
#include <runtime/JSObject.h>
#include <runtime/ObjectPrototype.h>

namespace WebCore {

class JSInjectedScriptHost : public JSDOMWrapper {
public:
    typedef JSDOMWrapper Base;
    static JSInjectedScriptHost* create(JSC::Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<InjectedScriptHost> impl)
    {
        JSInjectedScriptHost* ptr = new (JSC::allocateCell<JSInjectedScriptHost>(globalObject->globalData().heap)) JSInjectedScriptHost(structure, globalObject, impl);
        ptr->finishCreation(globalObject->globalData());
        return ptr;
    }

    static JSC::JSObject* createPrototype(JSC::ExecState*, JSC::JSGlobalObject*);
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier& propertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);

    // Custom functions
    JSC::JSValue evaluate(JSC::ExecState*);
    JSC::JSValue inspect(JSC::ExecState*);
    JSC::JSValue inspectedNode(JSC::ExecState*);
    JSC::JSValue internalConstructorName(JSC::ExecState*);
    JSC::JSValue isHTMLAllCollection(JSC::ExecState*);
    JSC::JSValue type(JSC::ExecState*);
    JSC::JSValue databaseId(JSC::ExecState*);
    JSC::JSValue storageId(JSC::ExecState*);
    InjectedScriptHost* impl() const { return m_impl.get(); }

private:
    RefPtr<InjectedScriptHost> m_impl;
protected:
    JSInjectedScriptHost(JSC::Structure*, JSDOMGlobalObject*, PassRefPtr<InjectedScriptHost>);
    void finishCreation(JSC::JSGlobalData&);
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

JSC::JSValue toJS(JSC::ExecState*, JSDOMGlobalObject*, InjectedScriptHost*);
InjectedScriptHost* toInjectedScriptHost(JSC::JSValue);

class JSInjectedScriptHostPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSC::JSObject* self(JSC::ExecState*, JSC::JSGlobalObject*);
    static JSInjectedScriptHostPrototype* create(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSInjectedScriptHostPrototype* ptr = new (JSC::allocateCell<JSInjectedScriptHostPrototype>(globalData.heap)) JSInjectedScriptHostPrototype(globalData, globalObject, structure);
        ptr->finishCreation(globalData);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSInjectedScriptHostPrototype(JSC::JSGlobalData& globalData, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(globalData, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | Base::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionClearConsoleMessages(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionEvaluate(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionCopyText(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInspect(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInspectedNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionInternalConstructorName(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionIsHTMLAllCollection(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionType(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionDatabaseId(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionStorageId(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionDidCreateWorker(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionDidDestroyWorker(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsInjectedScriptHostPrototypeFunctionNextWorkerId(JSC::ExecState*);
// Attributes

JSC::JSValue jsInjectedScriptHostConstructor(JSC::ExecState*, JSC::JSValue, const JSC::Identifier&);

} // namespace WebCore

#endif // ENABLE(INSPECTOR)

#endif
