/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHashChangeEvent.h"

#include "ExceptionCode.h"
#include "HashChangeEvent.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHashChangeEvent);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHashChangeEventTableValues[] =
{
    { "oldURL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHashChangeEventOldURL), (intptr_t)0 THUNK_GENERATOR(0) },
    { "newURL", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHashChangeEventNewURL), (intptr_t)0 THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHashChangeEventConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHashChangeEventTable = { 8, 7, JSHashChangeEventTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHashChangeEventConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHashChangeEventConstructorTable = { 1, 0, JSHashChangeEventConstructorTableValues, 0 };
const ClassInfo JSHashChangeEventConstructor::s_info = { "HashChangeEventConstructor", &DOMConstructorObject::s_info, &JSHashChangeEventConstructorTable, 0 };

JSHashChangeEventConstructor::JSHashChangeEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHashChangeEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHashChangeEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHashChangeEventConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHashChangeEventConstructor, JSDOMWrapper>(exec, &JSHashChangeEventConstructorTable, this, propertyName, slot);
}

bool JSHashChangeEventConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHashChangeEventConstructor, JSDOMWrapper>(exec, &JSHashChangeEventConstructorTable, this, propertyName, descriptor);
}

ConstructType JSHashChangeEventConstructor::getConstructData(ConstructData& constructData)
{
    constructData.native.function = constructJSHashChangeEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHashChangeEventPrototypeTableValues[] =
{
    { "initHashChangeEvent", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHashChangeEventPrototypeFunctionInitHashChangeEvent), (intptr_t)5 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHashChangeEventPrototypeTable = { 2, 1, JSHashChangeEventPrototypeTableValues, 0 };
const ClassInfo JSHashChangeEventPrototype::s_info = { "HashChangeEventPrototype", &JSC::JSNonFinalObject::s_info, &JSHashChangeEventPrototypeTable, 0 };

JSObject* JSHashChangeEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHashChangeEvent>(exec, globalObject);
}

bool JSHashChangeEventPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHashChangeEventPrototypeTable, this, propertyName, slot);
}

bool JSHashChangeEventPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHashChangeEventPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHashChangeEvent::s_info = { "HashChangeEvent", &JSEvent::s_info, &JSHashChangeEventTable, 0 };

JSHashChangeEvent::JSHashChangeEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HashChangeEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSHashChangeEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHashChangeEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHashChangeEventPrototype::create(exec->globalData(), globalObject, JSHashChangeEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSHashChangeEvent::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHashChangeEvent, Base>(exec, &JSHashChangeEventTable, this, propertyName, slot);
}

bool JSHashChangeEvent::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHashChangeEvent, Base>(exec, &JSHashChangeEventTable, this, propertyName, descriptor);
}

JSValue jsHashChangeEventOldURL(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHashChangeEvent* castedThis = static_cast<JSHashChangeEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HashChangeEvent* imp = static_cast<HashChangeEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->oldURL());
    return result;
}


JSValue jsHashChangeEventNewURL(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHashChangeEvent* castedThis = static_cast<JSHashChangeEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HashChangeEvent* imp = static_cast<HashChangeEvent*>(castedThis->impl());
    JSValue result = jsString(exec, imp->newURL());
    return result;
}


JSValue jsHashChangeEventConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHashChangeEvent* domObject = static_cast<JSHashChangeEvent*>(asObject(slotBase));
    return JSHashChangeEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSHashChangeEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHashChangeEventConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHashChangeEventPrototypeFunctionInitHashChangeEvent(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHashChangeEvent::s_info))
        return throwVMTypeError(exec);
    JSHashChangeEvent* castedThis = static_cast<JSHashChangeEvent*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHashChangeEvent::s_info);
    HashChangeEvent* imp = static_cast<HashChangeEvent*>(castedThis->impl());
    const String& type(ustringToString(exec->argument(0).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool canBubble(exec->argument(1).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    bool cancelable(exec->argument(2).toBoolean(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& oldURL(ustringToString(exec->argument(3).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& newURL(ustringToString(exec->argument(4).toString(exec)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    imp->initHashChangeEvent(type, canBubble, cancelable, oldURL, newURL);
    return JSValue::encode(jsUndefined());
}


}
