/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLVideoElement.h"

#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "HTMLVideoElement.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLVideoElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLVideoElementTableValues[] =
{
    { "width", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWidth), (intptr_t)setJSHTMLVideoElementWidth THUNK_GENERATOR(0) },
    { "height", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementHeight), (intptr_t)setJSHTMLVideoElementHeight THUNK_GENERATOR(0) },
    { "videoWidth", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementVideoWidth), (intptr_t)0 THUNK_GENERATOR(0) },
    { "videoHeight", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementVideoHeight), (intptr_t)0 THUNK_GENERATOR(0) },
    { "poster", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementPoster), (intptr_t)setJSHTMLVideoElementPoster THUNK_GENERATOR(0) },
    { "webkitSupportsFullscreen", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitSupportsFullscreen), (intptr_t)0 THUNK_GENERATOR(0) },
    { "webkitDisplayingFullscreen", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitDisplayingFullscreen), (intptr_t)0 THUNK_GENERATOR(0) },
#if ENABLE(MEDIA_STATISTICS)
    { "webkitDecodedFrameCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitDecodedFrameCount), (intptr_t)0 THUNK_GENERATOR(0) },
#endif
#if ENABLE(MEDIA_STATISTICS)
    { "webkitDroppedFrameCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementWebkitDroppedFrameCount), (intptr_t)0 THUNK_GENERATOR(0) },
#endif
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLVideoElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLVideoElementTable = { 32, 31, JSHTMLVideoElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLVideoElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLVideoElementConstructorTable = { 1, 0, JSHTMLVideoElementConstructorTableValues, 0 };
class JSHTMLVideoElementConstructor : public DOMConstructorObject {
private:
    JSHTMLVideoElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLVideoElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLVideoElementConstructor* ptr = new (JSC::allocateCell<JSHTMLVideoElementConstructor>(*exec->heap())) JSHTMLVideoElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLVideoElementConstructor::s_info = { "HTMLVideoElementConstructor", &DOMConstructorObject::s_info, &JSHTMLVideoElementConstructorTable, 0 };

JSHTMLVideoElementConstructor::JSHTMLVideoElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLVideoElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLVideoElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLVideoElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLVideoElementConstructor, JSDOMWrapper>(exec, &JSHTMLVideoElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLVideoElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLVideoElementConstructor, JSDOMWrapper>(exec, &JSHTMLVideoElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLVideoElementPrototypeTableValues[] =
{
    { "webkitEnterFullscreen", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreen), (intptr_t)0 THUNK_GENERATOR(0) },
    { "webkitExitFullscreen", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreen), (intptr_t)0 THUNK_GENERATOR(0) },
    { "webkitEnterFullScreen", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreen), (intptr_t)0 THUNK_GENERATOR(0) },
    { "webkitExitFullScreen", DontDelete | Function, (intptr_t)static_cast<NativeFunction>(jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreen), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLVideoElementPrototypeTable = { 8, 7, JSHTMLVideoElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLVideoElementPrototype::s_info = { "HTMLVideoElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLVideoElementPrototypeTable, 0 };

JSObject* JSHTMLVideoElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLVideoElement>(exec, globalObject);
}

bool JSHTMLVideoElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLVideoElementPrototypeTable, this, propertyName, slot);
}

bool JSHTMLVideoElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLVideoElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSHTMLVideoElement::s_info = { "HTMLVideoElement", &JSHTMLMediaElement::s_info, &JSHTMLVideoElementTable, 0 };

JSHTMLVideoElement::JSHTMLVideoElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLVideoElement> impl)
    : JSHTMLMediaElement(structure, globalObject, impl)
{
}

void JSHTMLVideoElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLVideoElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLVideoElementPrototype::create(exec->globalData(), globalObject, JSHTMLVideoElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLMediaElementPrototype::self(exec, globalObject)));
}

bool JSHTMLVideoElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLVideoElement, Base>(exec, &JSHTMLVideoElementTable, this, propertyName, slot);
}

bool JSHTMLVideoElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLVideoElement, Base>(exec, &JSHTMLVideoElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLVideoElementWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    JSValue result = jsNumber(std::max(0, imp->getIntegralAttribute(WebCore::HTMLNames::widthAttr)));
    return result;
}


JSValue jsHTMLVideoElementHeight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    JSValue result = jsNumber(std::max(0, imp->getIntegralAttribute(WebCore::HTMLNames::heightAttr)));
    return result;
}


JSValue jsHTMLVideoElementVideoWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->videoWidth());
    return result;
}


JSValue jsHTMLVideoElementVideoHeight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->videoHeight());
    return result;
}


JSValue jsHTMLVideoElementPoster(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(WebCore::HTMLNames::posterAttr));
    return result;
}


JSValue jsHTMLVideoElementWebkitSupportsFullscreen(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->webkitSupportsFullscreen());
    return result;
}


JSValue jsHTMLVideoElementWebkitDisplayingFullscreen(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->webkitDisplayingFullscreen());
    return result;
}


#if ENABLE(MEDIA_STATISTICS)
JSValue jsHTMLVideoElementWebkitDecodedFrameCount(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->webkitDecodedFrameCount());
    return result;
}

#endif

#if ENABLE(MEDIA_STATISTICS)
JSValue jsHTMLVideoElementWebkitDroppedFrameCount(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    JSValue result = jsNumber(imp->webkitDroppedFrameCount());
    return result;
}

#endif

JSValue jsHTMLVideoElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLVideoElement* domObject = static_cast<JSHTMLVideoElement*>(asObject(slotBase));
    return JSHTMLVideoElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLVideoElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLVideoElement, Base>(exec, propertyName, value, &JSHTMLVideoElementTable, this, slot);
}

void setJSHTMLVideoElementWidth(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(thisObject);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    imp->setUnsignedIntegralAttribute(WebCore::HTMLNames::widthAttr, value.toUInt32(exec));
}


void setJSHTMLVideoElementHeight(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(thisObject);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    imp->setUnsignedIntegralAttribute(WebCore::HTMLNames::heightAttr, value.toUInt32(exec));
}


void setJSHTMLVideoElementPoster(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(thisObject);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::posterAttr, valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLVideoElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLVideoElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullscreen(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLVideoElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLVideoElement::s_info);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    ExceptionCode ec = 0;

    imp->webkitEnterFullscreen(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullscreen(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLVideoElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLVideoElement::s_info);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());

    imp->webkitExitFullscreen();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitEnterFullScreen(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLVideoElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLVideoElement::s_info);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());
    ExceptionCode ec = 0;

    imp->webkitEnterFullScreen(ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLVideoElementPrototypeFunctionWebkitExitFullScreen(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLVideoElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLVideoElement* castedThis = static_cast<JSHTMLVideoElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLVideoElement::s_info);
    HTMLVideoElement* imp = static_cast<HTMLVideoElement*>(castedThis->impl());

    imp->webkitExitFullScreen();
    return JSValue::encode(jsUndefined());
}

HTMLVideoElement* toHTMLVideoElement(JSC::JSValue value)
{
    return value.inherits(&JSHTMLVideoElement::s_info) ? static_cast<JSHTMLVideoElement*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO)
