/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO_TRACK)

#include "JSHTMLTrackElement.h"

#include "HTMLNames.h"
#include "HTMLTrackElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLTrackElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLTrackElementTableValues[] =
{
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementSrc), (intptr_t)setJSHTMLTrackElementSrc THUNK_GENERATOR(0) },
    { "kind", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementKind), (intptr_t)setJSHTMLTrackElementKind THUNK_GENERATOR(0) },
    { "srclang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementSrclang), (intptr_t)setJSHTMLTrackElementSrclang THUNK_GENERATOR(0) },
    { "label", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementLabel), (intptr_t)setJSHTMLTrackElementLabel THUNK_GENERATOR(0) },
    { "isDefault", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementIsDefault), (intptr_t)setJSHTMLTrackElementIsDefault THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTrackElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLTrackElementTable = { 18, 15, JSHTMLTrackElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLTrackElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLTrackElementConstructorTable = { 1, 0, JSHTMLTrackElementConstructorTableValues, 0 };
class JSHTMLTrackElementConstructor : public DOMConstructorObject {
private:
    JSHTMLTrackElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLTrackElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLTrackElementConstructor* ptr = new (JSC::allocateCell<JSHTMLTrackElementConstructor>(*exec->heap())) JSHTMLTrackElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLTrackElementConstructor::s_info = { "HTMLTrackElementConstructor", &DOMConstructorObject::s_info, &JSHTMLTrackElementConstructorTable, 0 };

JSHTMLTrackElementConstructor::JSHTMLTrackElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTrackElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLTrackElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLTrackElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTrackElementConstructor, JSDOMWrapper>(exec, &JSHTMLTrackElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLTrackElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTrackElementConstructor, JSDOMWrapper>(exec, &JSHTMLTrackElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLTrackElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLTrackElementPrototypeTable = { 1, 0, JSHTMLTrackElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTrackElementPrototype::s_info = { "HTMLTrackElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLTrackElementPrototypeTable, 0 };

JSObject* JSHTMLTrackElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTrackElement>(exec, globalObject);
}

const ClassInfo JSHTMLTrackElement::s_info = { "HTMLTrackElement", &JSHTMLElement::s_info, &JSHTMLTrackElementTable, 0 };

JSHTMLTrackElement::JSHTMLTrackElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTrackElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTrackElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTrackElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTrackElementPrototype::create(exec->globalData(), globalObject, JSHTMLTrackElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTrackElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLTrackElement, Base>(exec, &JSHTMLTrackElementTable, this, propertyName, slot);
}

bool JSHTMLTrackElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLTrackElement, Base>(exec, &JSHTMLTrackElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLTrackElementSrc(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}


JSValue jsHTMLTrackElementKind(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->kind());
    return result;
}


JSValue jsHTMLTrackElementSrclang(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->srclang());
    return result;
}


JSValue jsHTMLTrackElementLabel(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->label());
    return result;
}


JSValue jsHTMLTrackElementIsDefault(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    JSValue result = jsBoolean(imp->hasAttribute(WebCore::HTMLNames::defaultAttr));
    return result;
}


JSValue jsHTMLTrackElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLTrackElement* domObject = static_cast<JSHTMLTrackElement*>(asObject(slotBase));
    return JSHTMLTrackElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTrackElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLTrackElement, Base>(exec, propertyName, value, &JSHTMLTrackElementTable, this, slot);
}

void setJSHTMLTrackElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    imp->setAttribute(WebCore::HTMLNames::srcAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLTrackElementKind(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    imp->setKind(ustringToString(value.toString(exec)));
}


void setJSHTMLTrackElementSrclang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    imp->setSrclang(ustringToString(value.toString(exec)));
}


void setJSHTMLTrackElementLabel(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    imp->setLabel(ustringToString(value.toString(exec)));
}


void setJSHTMLTrackElementIsDefault(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTrackElement* castedThis = static_cast<JSHTMLTrackElement*>(thisObject);
    HTMLTrackElement* imp = static_cast<HTMLTrackElement*>(castedThis->impl());
    imp->setBooleanAttribute(WebCore::HTMLNames::defaultAttr, value.toBoolean(exec));
}


JSValue JSHTMLTrackElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTrackElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(VIDEO_TRACK)
