/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLTitleElement.h"

#include "HTMLTitleElement.h"
#include "KURL.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLTitleElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLTitleElementTableValues[] =
{
    { "text", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTitleElementText), (intptr_t)setJSHTMLTitleElementText THUNK_GENERATOR(0) },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLTitleElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLTitleElementTable = { 4, 3, JSHTMLTitleElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLTitleElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLTitleElementConstructorTable = { 1, 0, JSHTMLTitleElementConstructorTableValues, 0 };
class JSHTMLTitleElementConstructor : public DOMConstructorObject {
private:
    JSHTMLTitleElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLTitleElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLTitleElementConstructor* ptr = new (JSC::allocateCell<JSHTMLTitleElementConstructor>(*exec->heap())) JSHTMLTitleElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLTitleElementConstructor::s_info = { "HTMLTitleElementConstructor", &DOMConstructorObject::s_info, &JSHTMLTitleElementConstructorTable, 0 };

JSHTMLTitleElementConstructor::JSHTMLTitleElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLTitleElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLTitleElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLTitleElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLTitleElementConstructor, JSDOMWrapper>(exec, &JSHTMLTitleElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLTitleElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLTitleElementConstructor, JSDOMWrapper>(exec, &JSHTMLTitleElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLTitleElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLTitleElementPrototypeTable = { 1, 0, JSHTMLTitleElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLTitleElementPrototype::s_info = { "HTMLTitleElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLTitleElementPrototypeTable, 0 };

JSObject* JSHTMLTitleElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLTitleElement>(exec, globalObject);
}

const ClassInfo JSHTMLTitleElement::s_info = { "HTMLTitleElement", &JSHTMLElement::s_info, &JSHTMLTitleElementTable, 0 };

JSHTMLTitleElement::JSHTMLTitleElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLTitleElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLTitleElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLTitleElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLTitleElementPrototype::create(exec->globalData(), globalObject, JSHTMLTitleElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLTitleElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLTitleElement, Base>(exec, &JSHTMLTitleElementTable, this, propertyName, slot);
}

bool JSHTMLTitleElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLTitleElement, Base>(exec, &JSHTMLTitleElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLTitleElementText(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLTitleElement* castedThis = static_cast<JSHTMLTitleElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLTitleElement* imp = static_cast<HTMLTitleElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->text());
    return result;
}


JSValue jsHTMLTitleElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLTitleElement* domObject = static_cast<JSHTMLTitleElement*>(asObject(slotBase));
    return JSHTMLTitleElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLTitleElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    lookupPut<JSHTMLTitleElement, Base>(exec, propertyName, value, &JSHTMLTitleElementTable, this, slot);
}

void setJSHTMLTitleElementText(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSHTMLTitleElement* castedThis = static_cast<JSHTMLTitleElement*>(thisObject);
    HTMLTitleElement* imp = static_cast<HTMLTitleElement*>(castedThis->impl());
    imp->setText(valueToStringWithNullCheck(exec, value));
}


JSValue JSHTMLTitleElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLTitleElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
