/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLSpanElement.h"

#include "HTMLSpanElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLSpanElement);

/* Hash table */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLSpanElementTableValues[] =
{
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSpanElementConstructor), (intptr_t)0 THUNK_GENERATOR(0) },
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLSpanElementTable = { 2, 1, JSHTMLSpanElementTableValues, 0 };
/* Hash table for constructor */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLSpanElementConstructorTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLSpanElementConstructorTable = { 1, 0, JSHTMLSpanElementConstructorTableValues, 0 };
class JSHTMLSpanElementConstructor : public DOMConstructorObject {
private:
    JSHTMLSpanElementConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSHTMLSpanElementConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSHTMLSpanElementConstructor* ptr = new (JSC::allocateCell<JSHTMLSpanElementConstructor>(*exec->heap())) JSHTMLSpanElementConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    virtual bool getOwnPropertySlot(JSC::ExecState*, const JSC::Identifier&, JSC::PropertySlot&);
    virtual bool getOwnPropertyDescriptor(JSC::ExecState*, const JSC::Identifier&, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::JSGlobalData& globalData, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(globalData, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSHTMLSpanElementConstructor::s_info = { "HTMLSpanElementConstructor", &DOMConstructorObject::s_info, &JSHTMLSpanElementConstructorTable, 0 };

JSHTMLSpanElementConstructor::JSHTMLSpanElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLSpanElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLSpanElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLSpanElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLSpanElementConstructor, JSDOMWrapper>(exec, &JSHTMLSpanElementConstructorTable, this, propertyName, slot);
}

bool JSHTMLSpanElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLSpanElementConstructor, JSDOMWrapper>(exec, &JSHTMLSpanElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */
#if ENABLE(JIT)
#define THUNK_GENERATOR(generator) , generator
#else
#define THUNK_GENERATOR(generator)
#endif

static const HashTableValue JSHTMLSpanElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0 THUNK_GENERATOR(0) }
};

#undef THUNK_GENERATOR
static JSC_CONST_HASHTABLE HashTable JSHTMLSpanElementPrototypeTable = { 1, 0, JSHTMLSpanElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLSpanElementPrototype::s_info = { "HTMLSpanElementPrototype", &JSC::JSNonFinalObject::s_info, &JSHTMLSpanElementPrototypeTable, 0 };

JSObject* JSHTMLSpanElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLSpanElement>(exec, globalObject);
}

const ClassInfo JSHTMLSpanElement::s_info = { "HTMLSpanElement", &JSHTMLElement::s_info, &JSHTMLSpanElementTable, 0 };

JSHTMLSpanElement::JSHTMLSpanElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLSpanElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLSpanElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLSpanElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLSpanElementPrototype::create(exec->globalData(), globalObject, JSHTMLSpanElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLSpanElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueSlot<JSHTMLSpanElement, Base>(exec, &JSHTMLSpanElementTable, this, propertyName, slot);
}

bool JSHTMLSpanElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    return getStaticValueDescriptor<JSHTMLSpanElement, Base>(exec, &JSHTMLSpanElementTable, this, propertyName, descriptor);
}

JSValue jsHTMLSpanElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSHTMLSpanElement* domObject = static_cast<JSHTMLSpanElement*>(asObject(slotBase));
    return JSHTMLSpanElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSHTMLSpanElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLSpanElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
